/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.InputStream;

public final class NewByteArrayInputStream
extends InputStream {
    private byte[] data;
    private int offset;
    private int length;

    public NewByteArrayInputStream(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public NewByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.offset = n;
        this.length = n2;
    }

    public int read() throws IOException {
        if (this.data == null) {
            throw new IOException();
        }
        if (this.length == 0) {
            return -1;
        }
        --this.length;
        return this.data[this.offset++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.data == null) {
            throw new IOException();
        }
        if (this.length == 0) {
            return -1;
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        System.arraycopy(this.data, this.offset, byArray, n, n2);
        this.offset += n2;
        this.length -= n2;
        return n2;
    }

    public long skip(long l) throws IOException {
        if (this.data == null) {
            throw new IOException();
        }
        if (this.length == 0) {
            return -1L;
        }
        if (l > (long)this.length) {
            l = this.length;
        }
        this.offset += (int)l;
        this.length -= (int)l;
        return l;
    }

    public int available() throws IOException {
        if (this.data == null) {
            throw new IOException();
        }
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public void close() {
        this.data = null;
    }
}

