/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.internal.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.AdviceBindingDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.AdviceBindingInheritance;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.ElementTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.IEditHelperAdviceDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.MetamodelDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.MetamodelTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.SpecializationTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;

public class SpecializationTypeRegistry {
    private static final Set ALL = Collections.singleton(AdviceBindingInheritance.ALL);
    private static final Set ALL_NONE = new HashSet(Arrays.asList(AdviceBindingInheritance.NONE, AdviceBindingInheritance.ALL));
    private final Map specializationTypeDescriptors = new HashMap();
    private final Map specializationsForTypeId = new HashMap();
    private final Map adviceBindings = new HashMap();

    public boolean registerSpecializationType(ISpecializationType specializationType) {
        if (specializationType == null || this.specializationTypeDescriptors.containsKey(specializationType.getId())) {
            return false;
        }
        SpecializationTypeDescriptor descriptor = new SpecializationTypeDescriptor(specializationType);
        return this.registerSpecializationType(descriptor);
    }

    public SpecializationTypeDescriptor registerSpecializationType(IConfigurationElement configElement, MetamodelDescriptor metamodelDescriptor) throws CoreException {
        SpecializationTypeDescriptor descriptor = new SpecializationTypeDescriptor(configElement, metamodelDescriptor);
        boolean wasRegistered = this.registerSpecializationType(descriptor);
        return wasRegistered ? descriptor : null;
    }

    private boolean registerSpecializationType(SpecializationTypeDescriptor descriptor) {
        if (this.checkForDuplicate(descriptor)) {
            return false;
        }
        this.specializationTypeDescriptors.put(descriptor.getId(), descriptor);
        IEditHelperAdviceDescriptor editHelperAdvice = descriptor.getEditHelperAdviceDescriptor();
        if (editHelperAdvice != null) {
            this.register(editHelperAdvice);
        }
        String[] specializedTypes = descriptor.getSpecializationTypeIds();
        int i = 0;
        while (i < specializedTypes.length) {
            HashSet<SpecializationTypeDescriptor> specializations = (HashSet<SpecializationTypeDescriptor>)this.specializationsForTypeId.get(specializedTypes[i]);
            if (specializations == null) {
                specializations = new HashSet<SpecializationTypeDescriptor>();
                this.specializationsForTypeId.put(specializedTypes[i], specializations);
            }
            specializations.add(descriptor);
            ++i;
        }
        return true;
    }

    public void registerAdviceBinding(IConfigurationElement configElement, MetamodelDescriptor metamodelDescriptor) throws CoreException {
        AdviceBindingDescriptor descriptor = new AdviceBindingDescriptor(configElement, metamodelDescriptor);
        this.register(descriptor);
    }

    private void register(IEditHelperAdviceDescriptor descriptor) {
        String targetId = descriptor.getTypeId();
        HashSet<IEditHelperAdviceDescriptor> bindings = (HashSet<IEditHelperAdviceDescriptor>)this.adviceBindings.get(targetId);
        if (bindings == null) {
            bindings = new HashSet<IEditHelperAdviceDescriptor>();
            this.adviceBindings.put(targetId, bindings);
        }
        bindings.add(descriptor);
    }

    public void removeSpecializationType(SpecializationTypeDescriptor specializationTypeDescriptor) {
        this.specializationTypeDescriptors.remove(specializationTypeDescriptor.getId());
        String[] specializedTypes = specializationTypeDescriptor.getSpecializationTypeIds();
        int j = 0;
        while (j < specializedTypes.length) {
            Set specializations = (Set)this.specializationsForTypeId.get(specializedTypes[j]);
            specializations.remove(specializationTypeDescriptor);
            ++j;
        }
    }

    private List getImmediateSpecializationTypeDescriptors(ElementTypeDescriptor type, IClientContext clientContext) {
        return this.getSpecializationTypeDescriptors(type, false, clientContext);
    }

    public ISpecializationType[] getAllSpecializationTypes(IElementTypeDescriptor type, IClientContext clientContext) {
        List descriptors = this.getSpecializationTypeDescriptors(type, true, clientContext);
        ISpecializationType[] result = new ISpecializationType[descriptors.size()];
        int index = 0;
        for (SpecializationTypeDescriptor next : descriptors) {
            result[index] = (ISpecializationType)next.getElementType();
            ++index;
        }
        return result;
    }

    private List getAllSpecializationTypeDescriptors(IElementTypeDescriptor type, IClientContext clientContext) {
        return this.getSpecializationTypeDescriptors(type, true, clientContext);
    }

    private List getSpecializationTypeDescriptors(IElementTypeDescriptor type, boolean deep, IClientContext clientContext) {
        Set specializationDescriptors;
        LinkedHashSet result = new LinkedHashSet();
        if (type != null && (specializationDescriptors = (Set)this.specializationsForTypeId.get(type.getId())) != null) {
            HashSet<SpecializationTypeDescriptor> specializations = new HashSet<SpecializationTypeDescriptor>();
            for (SpecializationTypeDescriptor nextDescriptor : specializationDescriptors) {
                if (!clientContext.includes(nextDescriptor) || nextDescriptor == null) continue;
                specializations.add(nextDescriptor);
                if (!deep) continue;
                result.addAll(this.getSpecializationTypeDescriptors(nextDescriptor, deep, clientContext));
            }
            result.addAll(specializations);
        }
        return new ArrayList(result);
    }

    public List getSpecializationDescriptorsMatching(EObject eObject, MetamodelTypeDescriptor metamodelTypeDescriptor, IClientContext clientContext) {
        ArrayList<SpecializationTypeDescriptor> result = new ArrayList<SpecializationTypeDescriptor>();
        List specializations = this.getAllSpecializationTypeDescriptors(metamodelTypeDescriptor, clientContext);
        for (SpecializationTypeDescriptor nextDescriptor : specializations) {
            IEditHelperAdviceDescriptor adviceDescriptor = nextDescriptor.getEditHelperAdviceDescriptor();
            if (adviceDescriptor != null) {
                if (!this.adviceMatches(eObject, adviceDescriptor)) continue;
                result.add(nextDescriptor);
                continue;
            }
            result.add(nextDescriptor);
        }
        return result;
    }

    public List getMatchingSpecializations(ElementTypeDescriptor type, EObject eContainer, EReference reference, IClientContext clientContext) {
        ArrayList result = new ArrayList();
        List matchingSpecializations = this.getSpecializationDescriptorsMatching(type, eContainer, reference, clientContext);
        result.addAll(matchingSpecializations);
        Iterator i = matchingSpecializations.iterator();
        while (i.hasNext()) {
            result.addAll(this.getMatchingSpecializations((ElementTypeDescriptor)i.next(), eContainer, reference, clientContext));
        }
        return result;
    }

    private boolean adviceMatches(EObject eObject, IEditHelperAdviceDescriptor editHelperAdviceDescriptor) {
        IElementMatcher containerMatcher;
        EReference containmentFeature = eObject.eContainmentFeature();
        IContainerDescriptor container = editHelperAdviceDescriptor.getContainerDescriptor();
        if (container != null && (containerMatcher = container.getMatcher()) != null && !containerMatcher.matches(eObject.eContainer())) {
            return false;
        }
        EReference[] features = null;
        if (container != null) {
            features = container.getContainmentFeatures();
        }
        if (features == null || features.length < 1) {
            IElementMatcher matcher = editHelperAdviceDescriptor.getMatcher();
            return matcher == null || matcher.matches(eObject);
        }
        int j = 0;
        while (j < features.length) {
            if (features[j] == containmentFeature) {
                IElementMatcher matcher = editHelperAdviceDescriptor.getMatcher();
                return matcher == null || matcher.matches(eObject);
            }
            ++j;
        }
        return false;
    }

    private List getSpecializationDescriptorsMatching(ElementTypeDescriptor typeDescriptor, EObject eContainer, EReference feature, IClientContext clientContext) {
        ArrayList<SpecializationTypeDescriptor> result = new ArrayList<SpecializationTypeDescriptor>();
        List specializationDescriptors = this.getImmediateSpecializationTypeDescriptors(typeDescriptor, clientContext);
        block0: for (SpecializationTypeDescriptor nextDescriptor : specializationDescriptors) {
            EReference[] features;
            IElementMatcher containerMatcher;
            if (!clientContext.includes(nextDescriptor)) continue;
            IContainerDescriptor container = nextDescriptor.getContainerDescriptor();
            IElementMatcher iElementMatcher = containerMatcher = container != null ? container.getMatcher() : null;
            if (containerMatcher != null && !containerMatcher.matches(eContainer)) continue;
            EReference[] eReferenceArray = features = container != null ? container.getContainmentFeatures() : null;
            if (features == null || features.length < 1) {
                EClass specializedType = nextDescriptor.getElementType().getEClass();
                if (!this.canContain(eContainer.eClass(), feature, specializedType)) continue;
                result.add(nextDescriptor);
                continue;
            }
            int j = 0;
            while (j < features.length) {
                if (features[j] == feature) {
                    result.add(nextDescriptor);
                    continue block0;
                }
                ++j;
            }
        }
        return result;
    }

    private boolean canContain(EClass container, EReference reference, EClass contained) {
        EClass eType;
        return reference.isContainment() && container.getEAllReferences().contains((Object)reference) && ((eType = (EClass)reference.getEType()).equals(contained) || eType.isSuperTypeOf(contained));
    }

    public List getEditHelperAdvice(EObject eObject, MetamodelTypeDescriptor metamodelTypeDescriptor, IClientContext clientContext) {
        LinkedHashSet result = new LinkedHashSet();
        IElementType[] metamodelSupertypes = metamodelTypeDescriptor.getElementType().getAllSuperTypes();
        int i = 0;
        while (i < metamodelSupertypes.length) {
            IElementType nextSupertype = metamodelSupertypes[i];
            result.addAll(this.getMatchingAdvice(nextSupertype.getId(), eObject, ALL, clientContext));
            ++i;
        }
        result.addAll(this.getMatchingAdvice(metamodelTypeDescriptor.getId(), eObject, ALL_NONE, clientContext));
        List specializationDescriptors = this.getSpecializationDescriptorsMatching(eObject, metamodelTypeDescriptor, clientContext);
        Collections.reverse(specializationDescriptors);
        for (SpecializationTypeDescriptor nextSpecialization : specializationDescriptors) {
            result.addAll(this.getMatchingAdvice(nextSpecialization.getId(), eObject, ALL_NONE, clientContext));
        }
        return new ArrayList(result);
    }

    public List getEditHelperAdvice(IElementType elementType, MetamodelTypeDescriptor metamodelTypeDescriptor, IClientContext clientContext) {
        LinkedHashSet result = new LinkedHashSet();
        String metamodelTypeId = metamodelTypeDescriptor != null ? metamodelTypeDescriptor.getId() : null;
        IElementType[] metamodelSupertypes = elementType.getAllSuperTypes();
        int i = 0;
        while (i < metamodelSupertypes.length) {
            IElementType nextSupertype = metamodelSupertypes[i];
            if (nextSupertype instanceof ISpecializationType || nextSupertype.getId().equals(metamodelTypeId)) {
                result.addAll(this.getMatchingAdvice(nextSupertype.getId(), ALL_NONE, clientContext));
            } else if (nextSupertype instanceof IMetamodelType) {
                result.addAll(this.getMatchingAdvice(nextSupertype.getId(), ALL, clientContext));
            }
            ++i;
        }
        result.addAll(this.getMatchingAdvice(elementType.getId(), ALL_NONE, clientContext));
        return new ArrayList(result);
    }

    private List getMatchingAdvice(String elementTypeId, EObject eObject, Set adviceInheritanceToConsider, IClientContext clientContext) {
        ArrayList<IEditHelperAdvice> result = new ArrayList<IEditHelperAdvice>();
        Iterator j = this.getAdviceBindings(elementTypeId);
        while (j.hasNext()) {
            IEditHelperAdvice nextAdvice;
            IEditHelperAdviceDescriptor nextAdviceDescriptor = (IEditHelperAdviceDescriptor)j.next();
            if (!clientContext.includes(nextAdviceDescriptor) || !this.adviceMatches(eObject, nextAdviceDescriptor) || !adviceInheritanceToConsider.contains((Object)nextAdviceDescriptor.getInheritance()) || (nextAdvice = nextAdviceDescriptor.getEditHelperAdvice()) == null) continue;
            result.add(nextAdvice);
        }
        return result;
    }

    private List getMatchingAdvice(String elementTypeId, Set adviceInheritanceToConsider, IClientContext clientContext) {
        ArrayList<IEditHelperAdvice> result = new ArrayList<IEditHelperAdvice>();
        Iterator j = this.getAdviceBindings(elementTypeId);
        while (j.hasNext()) {
            IEditHelperAdvice nextAdvice;
            IEditHelperAdviceDescriptor nextAdviceDescriptor = (IEditHelperAdviceDescriptor)j.next();
            if (!clientContext.includes(nextAdviceDescriptor) || !adviceInheritanceToConsider.contains((Object)nextAdviceDescriptor.getInheritance()) || (nextAdvice = nextAdviceDescriptor.getEditHelperAdvice()) == null) continue;
            result.add(nextAdvice);
        }
        return result;
    }

    private Iterator getAdviceBindings(String elementTypeId) {
        class MultiIterator
        implements Iterator {
            private Iterator current;
            private Collection[] collections;
            private int index = 0;

            MultiIterator(Collection[] collections) {
                this.collections = collections;
                this.current = this.nextIterator();
            }

            public boolean hasNext() {
                while (this.current != null) {
                    if (this.current.hasNext()) {
                        return true;
                    }
                    this.current = this.nextIterator();
                }
                return false;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private Iterator nextIterator() {
                Iterator result = null;
                while (result == null && this.index < this.collections.length) {
                    if (this.collections[this.index] != null) {
                        result = this.collections[this.index].iterator();
                        this.collections[this.index] = null;
                    }
                    ++this.index;
                }
                return result;
            }
        }
        return new MultiIterator(new Collection[]{(Collection)this.adviceBindings.get(elementTypeId), (Collection)this.adviceBindings.get("*")});
    }

    public SpecializationTypeDescriptor getSpecializationTypeDescriptor(String id) {
        return (SpecializationTypeDescriptor)this.specializationTypeDescriptors.get(id);
    }

    public Collection getSpecializationTypeDescriptors() {
        return this.specializationTypeDescriptors.values();
    }

    public Collection getSpecializationTypeDescriptors(IClientContext clientContext) {
        ArrayList<ISpecializationTypeDescriptor> result = new ArrayList<ISpecializationTypeDescriptor>();
        for (ISpecializationTypeDescriptor next : this.getSpecializationTypeDescriptors()) {
            if (!clientContext.includes(next)) continue;
            result.add(next);
        }
        return result;
    }

    private boolean checkForDuplicate(ElementTypeDescriptor typeDescriptor) {
        if (this.specializationTypeDescriptors.containsKey(typeDescriptor.getId())) {
            Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)11, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.type_not_init_WARN_, (Object)typeDescriptor.getId(), (Object)EMFTypeCoreMessages.type_reason_duplicate_id_WARN_));
            return true;
        }
        return false;
    }
}

