/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;

public class NullLiteralType
extends LiteralType {
    public static final NullLiteralType SINGLETON = new NullLiteralType();

    private NullLiteralType() {
        super("V");
    }

    public Boolean coerceToBoolean() throws TypeCoercionException {
        return Boolean.FALSE;
    }

    public Number coerceToNumber(Class T) throws TypeCoercionException {
        if (T == BigInteger.class) {
            return BigInteger.ZERO;
        }
        if (T == BigDecimal.class) {
            return new BigDecimal(0.0);
        }
        if (T == Double.class || T == Double.TYPE) {
            return new Double(0.0);
        }
        if (T == Float.class || T == Float.TYPE) {
            return new Float(0.0);
        }
        if (T == Long.class || T == Long.TYPE) {
            return 0L;
        }
        if (T == Integer.class || T == Integer.TYPE) {
            return 0;
        }
        if (T == Short.class || T == Short.TYPE) {
            return (short)0;
        }
        if (T == Byte.class || T == Byte.TYPE) {
            return (byte)0;
        }
        throw new IllegalArgumentException("Not a target numeric type: " + T);
    }

    public String getLiteralValue() {
        return "";
    }

    public Object getLiteralValueRaw() {
        return null;
    }
}

