/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.introspection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.RegistryReader;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.internal.introspection.ModelIntrospectionManager;
import org.eclipse.stp.core.introspection.IComponentTypeIntrospector;
import org.eclipse.stp.core.introspection.IShareableComponentTypeFactory;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.UnknownImplementation;

public class ComponentTypeIntrospectorRegistry
extends RegistryReader {
    private static final String COMPONENT_TYPE_INTROSPECTOR = "componentTypeIntrospector";
    private static final String ATT_EXTENSION = "extension";
    private static final String ATT_CLASS = "class";
    private static final String ATT_IMPLEMENTATION_TYPE = "implementationElementType";
    private static final String ATT_URI_FACTORY_CLASS = "shareableURIFactoryClass";
    private static ComponentTypeIntrospectorRegistry instance;
    private final Map introspectionExtensions = new HashMap();
    private final Map substitutionGroups = new HashMap();
    private final Map shareableFactories = new HashMap();

    public ComponentTypeIntrospectorRegistry() {
        super(Platform.getExtensionRegistry(), STPCorePlugin.PLUGIN_ID, COMPONENT_TYPE_INTROSPECTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentTypeIntrospectorRegistry getInstance() {
        if (instance != null) {
            return instance;
        }
        String string = COMPONENT_TYPE_INTROSPECTOR;
        synchronized (COMPONENT_TYPE_INTROSPECTOR) {
            if (instance == null) {
                instance = new ComponentTypeIntrospectorRegistry();
                instance.readRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean hasIntrospector(URI implementation) {
        return this.introspectionExtensions.containsKey(implementation.fileExtension());
    }

    public URI getShareableURI(Implementation anImplementation) {
        IFile shareableFile;
        IShareableComponentTypeFactory factory = this.getShareableFactory(anImplementation);
        if (factory != null && (shareableFile = factory.findShareableFile(ModelIntrospectionManager.getStructuralFeature(anImplementation), anImplementation)) != null) {
            return URI.createURI((String)("comptype:" + shareableFile.getFullPath().toString()));
        }
        return null;
    }

    public IComponentTypeIntrospector createAndBindIntrospector(ComponentType aComponentType, URI implementation) {
        IConfigurationElement configuration = (IConfigurationElement)this.introspectionExtensions.get(implementation.fileExtension());
        if (configuration != null) {
            try {
                IComponentTypeIntrospector introspector = (IComponentTypeIntrospector)configuration.createExecutableExtension(ATT_CLASS);
                UnknownImplementation unknownImplemenation = SCAFactory.eINSTANCE.createUnknownImplementation();
                unknownImplemenation.setUri(implementation.toString());
                aComponentType.getEObject().eAdapters().add((Object)introspector);
                introspector.init(unknownImplemenation);
                return introspector;
            }
            catch (CoreException e) {
                STPCorePlugin.logError(0, Messages.Could_not_create_class, e);
            }
        }
        return null;
    }

    public IComponentTypeIntrospector createIntrospector(Implementation implementation) {
        Assert.isNotNull((Object)implementation.getEObject().eContainer());
        String serializedSubstitutionGroupElement = ModelIntrospectionManager.getSubstitutionGroupName(implementation);
        IConfigurationElement configuration = (IConfigurationElement)this.substitutionGroups.get(serializedSubstitutionGroupElement);
        if (configuration != null) {
            try {
                IComponentTypeIntrospector introspector = (IComponentTypeIntrospector)configuration.createExecutableExtension(ATT_CLASS);
                introspector.init(implementation);
                return introspector;
            }
            catch (CoreException e) {
                STPCorePlugin.logError(0, Messages.Could_not_create_class, e);
            }
        }
        return null;
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getAttribute(ATT_EXTENSION) != null) {
            this.introspectionExtensions.put(element.getAttribute(ATT_EXTENSION), element);
        }
        if (element.getAttribute(ATT_IMPLEMENTATION_TYPE) != null) {
            this.substitutionGroups.put(element.getAttribute(ATT_IMPLEMENTATION_TYPE), element);
        }
        return true;
    }

    public IShareableComponentTypeFactory getShareableFactory(Implementation implementation) {
        return this.getShareableFactory(ModelIntrospectionManager.getSubstitutionGroupName(implementation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IShareableComponentTypeFactory getShareableFactory(final String serializedElement) {
        IShareableComponentTypeFactory factory = (IShareableComponentTypeFactory)this.shareableFactories.get(serializedElement);
        if (factory != null) {
            return factory;
        }
        Map map = this.shareableFactories;
        synchronized (map) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    IConfigurationElement element = (IConfigurationElement)ComponentTypeIntrospectorRegistry.this.substitutionGroups.get(serializedElement);
                    if (element != null) {
                        IShareableComponentTypeFactory factory = (IShareableComponentTypeFactory)element.createExecutableExtension(ComponentTypeIntrospectorRegistry.ATT_URI_FACTORY_CLASS);
                        ComponentTypeIntrospectorRegistry.this.shareableFactories.put(serializedElement, factory);
                    }
                }

                public void handleException(Throwable exception) {
                }
            };
            Platform.run((ISafeRunnable)runnable);
        }
        return (IShareableComponentTypeFactory)this.shareableFactories.get(serializedElement);
    }
}

