/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.message.BPlaneTransactionClient;
import org.eclipse.stp.b2j.core.jengine.internal.message.BPlaneTransactionServer;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.TransactionListener;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.Session;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.SessionFactory;
import org.eclipse.stp.b2j.core.jengine.internal.utils.UIDPool;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class TransportTunnel
implements TransactionListener {
    private static int UID_SHIFT = 10000;
    UIDPool pool = new UIDPool();
    SessionAddress address;
    Session session;
    BPlaneTransactionClient tclient;
    BPlaneTransactionServer tserver;
    static final int CREATE_SERVER = 10;
    static final int CREATE_FORWARDER = 20;
    static final int CREATE_FORWARDER_FAILED = 21;
    static final int KILL_FORWARDERS = 30;
    Object f_LOCK = new Object();
    HashMap f_to = new HashMap();
    HashMap f_from = new HashMap();

    public Message doTransaction(Message m) {
        int type = m.getType();
        if (type == 10) {
            Integer local_port = (Integer)m.get(0);
            String remote_host = (String)m.get(1);
            Integer remote_port = (Integer)m.get(2);
            System.out.println("CREATE SERVER: " + local_port + " -> " + remote_host + ":" + remote_port);
            Server server = new Server(local_port, remote_host, remote_port);
            server.start();
        } else if (type == 20) {
            String remote_host = (String)m.get(0);
            Integer remote_port = (Integer)m.get(1);
            Integer uid = (Integer)m.get(2);
            try {
                Socket sock = new Socket(remote_host, (int)remote_port);
                this.createForwarder(sock, uid, false);
            }
            catch (Exception e) {
                m = new Message(21);
                m.append("" + e);
            }
        } else if (type == 30) {
            int uid = (Integer)m.get(0);
            this.killForwarders(uid);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killForwarders(int uid) {
        Object object = this.f_LOCK;
        synchronized (object) {
            Integer n = new Integer(uid);
            Forwarder to = (Forwarder)this.f_to.get(n);
            Forwarder from = (Forwarder)this.f_from.get(n);
            to.finish = true;
            from.finish = true;
            try {
                to.interrupt();
            }
            catch (Throwable throwable) {}
            try {
                from.interrupt();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createForwarder(Socket sock, int uid, boolean direction) throws IOException {
        Object object = this.f_LOCK;
        synchronized (object) {
            Forwarder to = new Forwarder(uid, direction, new BufferedInputStream(sock.getInputStream()), this.session.getOutputStream((short)uid));
            Forwarder from = new Forwarder(uid, false, this.session.getInputStream((short)uid), new BufferedOutputStream(sock.getOutputStream()));
            from.start();
            to.start();
            Integer n = new Integer(uid);
            this.f_to.put(n, to);
            this.f_from.put(n, from);
        }
    }

    public static void main(String[] argsarray) {
        new TransportTunnel(argsarray);
    }

    private void usage() {
        System.out.println("Usage: TransportTunnel <options>");
        System.out.println("Options:");
        System.out.println("  -h                  show this help");
        System.out.println("  -from PORT          accept incomming tunnel connections on PORT");
        System.out.println("  -to HOST PORT       create a new tunnel connection to HOST on PORT");
        System.out.println("  -ls PORT HOST PORT  create a local server forwarding data from local PORT to HOST:PORT");
        System.out.println("  -rs PORT HOST PORT  create a remote server forwarding data from remote PORT to HOST:PORT");
        System.out.println("  -rc TIMEOUT         automatic reconnect with a specified TIMEOUT in milliseconds");
        System.out.println("");
        System.out.println("E.g. TransportTunnel -from 10000");
        System.out.println("");
        System.out.println("     (then) TransportTunnel -to myhost 10000  -ls 80 www.google.com 80");
        System.exit(1);
    }

    public TransportTunnel(String[] argsarray) {
        try {
            String arg;
            ArrayList<String> arglist = new ArrayList<String>();
            int i = 0;
            while (i < argsarray.length) {
                arglist.add(argsarray[i]);
                ++i;
            }
            short line = -1;
            int i2 = 0;
            while (i2 < arglist.size()) {
                arg = (String)arglist.get(i2);
                if (arg.equals("-from")) {
                    if (this.address != null) {
                        this.usage();
                    }
                    arglist.remove(i2);
                    int port = Integer.parseInt((String)arglist.remove(i2));
                    this.address = new SessionAddress("localhost", -1, -1, "localhost", port, port);
                    this.address.setRequiresMultipleStreams(true);
                    this.session = SessionFactory.newSession(this.address, false);
                    line = 0;
                    UID_SHIFT = 10000;
                    --i2;
                } else if (arg.equals("-to")) {
                    if (this.address != null) {
                        this.usage();
                    }
                    arglist.remove(i2);
                    String host = (String)arglist.remove(i2);
                    int port = Integer.parseInt((String)arglist.remove(i2));
                    this.address = new SessionAddress("localhost", -1, -1, host, port, port);
                    this.address.setRequiresMultipleStreams(true);
                    this.session = SessionFactory.newSession(this.address, true);
                    line = 1;
                    UID_SHIFT = 20000;
                    --i2;
                } else if (arg.equals("-rc")) {
                    arglist.remove(i2);
                    long timeout = Long.parseLong((String)arglist.remove(i2));
                    this.address.setRequiresLinkReconnection(true);
                    this.address.setReconnectionFailureAbortTimeout(timeout);
                    --i2;
                } else if (arg.equals("-h")) {
                    this.usage();
                }
                ++i2;
            }
            this.session.begin();
            if (this.session == null) {
                throw new Exception("You must specify one of '-from' or '-to'");
            }
            System.out.println("INCOMING ON LINE " + line);
            this.tserver = new BPlaneTransactionServer(this.session.getInputStream(line), this.session.getOutputStream(line), this);
            line = (short)(1 - line);
            System.out.println("OUTGOING ON LINE " + line);
            this.tclient = new BPlaneTransactionClient(this.session.getInputStream(line), this.session.getOutputStream(line));
            System.out.println("CONNECTION ESTABLISHED");
            i2 = 0;
            while (i2 < arglist.size()) {
                Message m;
                arg = (String)arglist.get(i2);
                if (arg.equals("-h")) {
                    this.usage();
                } else if (arg.equals("-ls")) {
                    arglist.remove(i2);
                    int lport = Integer.parseInt((String)arglist.remove(i2));
                    String rhost = (String)arglist.remove(i2);
                    int rport = Integer.parseInt((String)arglist.remove(i2));
                    System.out.println(String.valueOf(lport) + " ==> " + rhost + ":" + rport);
                    m = new Message(10);
                    m.append(lport);
                    m.append(rhost);
                    m.append(rport);
                    this.doTransaction(m);
                    --i2;
                } else if (arg.equals("-rs")) {
                    arglist.remove(i2);
                    int rport = Integer.parseInt((String)arglist.remove(i2));
                    String lhost = (String)arglist.remove(i2);
                    int lport = Integer.parseInt((String)arglist.remove(i2));
                    System.out.println(String.valueOf(lhost) + ":" + lport + " <== " + rport);
                    m = new Message(10);
                    m.append(rport);
                    m.append(lhost);
                    m.append(lport);
                    this.tclient.doTransaction(m);
                    --i2;
                } else {
                    System.err.println("Unrecognised argument: " + arg);
                    System.exit(1);
                }
                ++i2;
            }
            System.out.println("SETUP COMPLETE");
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid number, " + e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Forwarder
    extends Thread {
        InputStream in;
        OutputStream out;
        int uid;
        boolean finish = false;
        boolean killer = false;

        public Forwarder(int uid, boolean killer, InputStream in, OutputStream out) {
            this.uid = uid;
            this.in = in;
            this.out = out;
            this.killer = killer;
        }

        public void run() {
            try {
                if (this.killer) {
                    System.out.println("Forwarder: >> " + this.uid);
                } else {
                    System.out.println("Forwarder: << " + this.uid);
                }
                byte[] buf = new byte[4096];
                int n = 0;
                while (!this.finish) {
                    n = this.in.read(buf, 0, 4096);
                    if (n > 0) {
                        this.out.write(buf, 0, n);
                        this.out.flush();
                        continue;
                    }
                    if (n != -1) continue;
                    return;
                }
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {}
            if (this.killer) {
                try {
                    TransportTunnel.this.killForwarders(this.uid);
                }
                catch (Throwable throwable) {}
                try {
                    Message m = new Message(30);
                    m.append(this.uid);
                    TransportTunnel.this.tclient.doTransaction(m);
                }
                catch (Throwable throwable) {}
                try {
                    Thread.sleep(5000L);
                }
                catch (Throwable throwable) {}
                TransportTunnel.this.pool.releaseUID(this.uid - UID_SHIFT);
            }
        }
    }

    class Server
    extends Thread {
        int port;
        String rhost;
        int rport;

        public Server(int port, String rhost, int rport) {
            this.port = port;
            this.rhost = rhost;
            this.rport = rport;
        }

        public void run() {
            try {
                ServerSocket server = new ServerSocket(this.port);
                while (true) {
                    Socket sock = server.accept();
                    try {
                        int uid = TransportTunnel.this.pool.getUID();
                        Message m = new Message(20);
                        m.append(this.rhost);
                        m.append(this.rport);
                        m.append(UID_SHIFT + uid);
                        m = TransportTunnel.this.tclient.doTransaction(m);
                        if (m.getType() == 21) {
                            throw new Exception("Forwarder create failed");
                        }
                        TransportTunnel.this.createForwarder(sock, UID_SHIFT + uid, true);
                    }
                    catch (Exception e) {
                        System.out.println("Forwarder ended: " + e);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

