/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.internal.emf.resource.AbstractRendererImpl;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXDocumentHandler;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXWriter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;

public class EMF2SAXRenderer
extends AbstractRendererImpl {
    public void doLoad(InputStream in, Map options) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(this.isValidating());
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            EMF2SAXDocumentHandler handler = new EMF2SAXDocumentHandler(this.getResource());
            try {
                reader.setFeature("http://xml.org/sax/features/validation", this.isValidating());
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {}
            try {
                reader.setFeature("http://apache.org/xml/features/validation/schema", this.isValidating());
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                reader.setFeature("http://xml.org/sax/features/validation", false);
                Logger.getLogger().log((Object)"Warning: Parser does not support \"http://apache.org/xml/features/validation/schema\". Validation will be disabled.");
            }
            try {
                reader.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                Logger.getLogger().log((Object)"Warning: Parser does not support \"http://apache.org/xml/features/allow-java-encodings\".");
            }
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.setEntityResolver(handler);
            InputSource testsource = new InputSource(in);
            reader.parse(testsource);
        }
        catch (RuntimeException t_rex) {
            throw t_rex;
        }
        catch (Exception ex) {
            throw new WrappedException(ex);
        }
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        TransformerHandler handler = null;
        try {
            try {
                SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
                handler = factory.newTransformerHandler();
                handler.setResult(new StreamResult(outputStream));
                Transformer transformer = handler.getTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", this.getResource().getEncoding());
                transformer.setOutputProperty("version", this.getResource().getXMLVersion());
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("omit-xml-declaration", "no");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                if (this.getResource().getPublicId() != null) {
                    transformer.setOutputProperty("doctype-public", this.getResource().getPublicId());
                }
                if (this.getResource().getSystemId() != null) {
                    transformer.setOutputProperty("doctype-system", this.getResource().getSystemId());
                }
            }
            catch (TransformerConfigurationException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (TransformerFactoryConfigurationError e) {
                Logger.getLogger().logError((Throwable)e);
            }
            if (handler == null) {
                Logger.getLogger((String)"SAX Writer is null");
                return;
            }
            EMF2SAXWriter writer = new EMF2SAXWriter();
            writer.serialize(this.resource, handler);
        }
        catch (SAXException saxe) {
            throw new WrappedException((Exception)saxe);
        }
    }

    public void prepareToAddContents() {
    }

    public int getVersionID() {
        return this.getResource().getVersionID();
    }
}

