/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.utilities;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.common.internal.emf.utilities.TranslatorManager;

public class TranslatorService {
    private static final Map translators = new HashMap();
    private static final TranslatorService INSTANCE = new TranslatorService();

    private TranslatorService() {
    }

    public static TranslatorService getInstance() {
        return INSTANCE;
    }

    public TranslatorManager.TranslatorDescriptor[] getTranslatorDescriptors() {
        return TranslatorManager.getInstance().findTranslators();
    }

    public Translator[] getTranslators() {
        TranslatorManager.TranslatorDescriptor[] descriptors = this.getTranslatorDescriptors();
        Translator[] result = new Translator[descriptors.length];
        int resultIndex = 0;
        int i = 0;
        while (i < descriptors.length) {
            Translator instance = this.getTranslator(descriptors[i]);
            if (instance != null) {
                result[resultIndex] = instance;
                ++resultIndex;
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Translator getTranslator(TranslatorManager.TranslatorDescriptor translatorDescriptor) {
        Translator translator = (Translator)translators.get(translatorDescriptor);
        if (translator != null) {
            return translator;
        }
        Map map = translators;
        synchronized (map) {
            translator = translatorDescriptor.createTranslator();
            if (translator != null) {
                translators.put(translatorDescriptor, translator);
            }
        }
        return translator;
    }
}

