/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ant;

import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.EnvironmentMessages;
import org.eclipse.wst.command.internal.env.ant.AntController;
import org.eclipse.wst.command.internal.env.ant.PropertyDataHolder;
import org.eclipse.wst.command.internal.env.core.CommandManager;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.command.internal.env.core.data.BeanModifier;
import org.eclipse.wst.command.internal.env.core.data.ClassEntry;
import org.eclipse.wst.command.internal.env.core.data.Transformer;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.eclipse.EclipseEnvironment;
import org.eclipse.wst.command.internal.env.eclipse.IEclipseStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AntEnvironment
extends EclipseEnvironment {
    private Hashtable antProperties_;
    private Hashtable operationDataRecord_ = new Hashtable();
    private boolean mappingComplete_;
    private ClassEntry classEntry;
    private static String MAPPER_EXT_PT = "antDataMapping";
    private static String SCENARIO_EXT_PT = "antScenario";
    private static String EXT_PT_NAMESPACE = "org.eclipse.wst.command.env";
    private static final String MAPPER_OPERATION_ATTRIBUTE = "operation";
    private static final String MAPPER_KEY_ATTRIBUTE = "key";
    private static final String MAPPER_PROPERTY_ATTRIBUTE = "property";
    private static final String MAPPER_TRANSFORM_ATTRIBUTE = "transform";
    private static final String MAPPER_REQUIRED_ATTRIBUTE = "required";
    private static final String SCENARIO_TYPE_ATTRIBUTE = "scenarioType";
    private static final String SCENARIO_CLASS_ATTRIBUTE = "class";
    private static final String VERBOSE_PROPERTY = "Verbose";
    private static final String OVERWRITE_PROPERTY = "OverwriteFilesEnabled";
    private static final String CREATEFOLDER_PROPERTY = "CreateFoldersEnabled";
    private static final String CHECKOUT_PROPERTY = "CheckoutFilesEnabled";
    private static final String SCENARIO_TYPE_PROPERTY = "ScenarioType";
    private AntController controller_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public AntEnvironment(AntController controller, TransientResourceContext context, IEclipseStatusHandler handler, Hashtable properties) {
        super(controller.getOperationManager(), (ResourceContext)context, handler);
        this.antProperties_ = properties;
        this.controller_ = controller;
        this.setContext(context);
    }

    private void setContext(TransientResourceContext context) {
        Boolean overwriteSet = this.getBooleanProperty(OVERWRITE_PROPERTY);
        Boolean createfolderSet = this.getBooleanProperty(CREATEFOLDER_PROPERTY);
        Boolean checkoutSet = this.getBooleanProperty(CHECKOUT_PROPERTY);
        if (overwriteSet != null) {
            context.setOverwriteFilesEnabled(overwriteSet.booleanValue());
        }
        if (createfolderSet != null) {
            context.setCreateFoldersEnabled(createfolderSet.booleanValue());
        }
        if (checkoutSet != null) {
            context.setCheckoutFilesEnabled(checkoutSet.booleanValue());
        }
    }

    public boolean verbose() {
        Boolean result = this.getBooleanProperty(VERBOSE_PROPERTY);
        return result == null ? false : result;
    }

    public Boolean getBooleanProperty(String property) {
        String value = this.getProperty(property);
        Boolean result = null;
        if (value != null) {
            value = value.toLowerCase();
            result = new Boolean(value.equals("true"));
        }
        return result;
    }

    private String getProperty(String key) {
        Object property = this.antProperties_.get(key);
        if (property != null && !property.toString().equals("")) {
            return property.toString().trim();
        }
        return null;
    }

    public IStatus initOperationData(AbstractDataModelOperation op) {
        String qualifiedClassName = op.getClass().getName();
        if (this.operationDataRecord_.get(qualifiedClassName) == null) {
            this.classEntry = new ClassEntry();
            try {
                Enumeration operationData = this.getMappingExtensions(op);
                this.classEntry.setterList_ = this.getSetterList(op);
                while (operationData.hasMoreElements()) {
                    PropertyDataHolder mapping = (PropertyDataHolder)operationData.nextElement();
                    this.mappingComplete_ = false;
                    String property = mapping.property_;
                    String setterMethodName = this.createSetterName(property);
                    int step = 1;
                    while (!this.mappingComplete_) {
                        switch (step) {
                            case 1: {
                                this.mappingComplete_ = this.transformAndSet(mapping, setterMethodName);
                                break;
                            }
                            case 2: {
                                this.mappingComplete_ = this.callSetter(mapping.operation_, mapping.value_, setterMethodName);
                                break;
                            }
                            case 3: {
                                this.mappingComplete_ = this.callPrimitiveSetter(mapping);
                                break;
                            }
                            case 4: {
                                this.mappingComplete_ = this.callSetterConstructor(mapping);
                                break;
                            }
                            default: {
                                this.mappingComplete_ = true;
                            }
                        }
                        ++step;
                    }
                }
                this.operationDataRecord_.put(qualifiedClassName, "");
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return Status.OK_STATUS;
    }

    private String createSetterName(String property) {
        while (property.indexOf(".") >= 0) {
            property = property.substring(property.indexOf(".") + 1);
        }
        String firstChar = property.substring(0, 1);
        firstChar = firstChar.toUpperCase();
        property = String.valueOf(firstChar) + property.substring(1);
        String setterName = "set" + property;
        return setterName;
    }

    private Enumeration getMappingExtensions(AbstractDataModelOperation operation) throws CoreException {
        String operationName = operation.getClass().getName();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint extPt = reg.getExtensionPoint(EXT_PT_NAMESPACE, MAPPER_EXT_PT);
        Hashtable<String, PropertyDataHolder> dataTable = new Hashtable<String, PropertyDataHolder>(25);
        IConfigurationElement[] elements = extPt.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement ce = elements[i];
            String obj = ce.getAttribute(MAPPER_OPERATION_ATTRIBUTE);
            if (obj.equals(operationName)) {
                Status statusObj;
                String msg;
                String key = ce.getAttribute(MAPPER_KEY_ATTRIBUTE);
                String value = this.getProperty(key);
                if (value != null) {
                    PropertyDataHolder holder;
                    String property = ce.getAttribute(MAPPER_PROPERTY_ATTRIBUTE);
                    Object transform = null;
                    try {
                        if (ce.getAttribute(MAPPER_TRANSFORM_ATTRIBUTE) != null) {
                            transform = ce.createExecutableExtension(MAPPER_TRANSFORM_ATTRIBUTE);
                        }
                    }
                    catch (CoreException cex) {
                        Status errorStatus = new Status(4, "ws_ant", 5092, cex.getMessage(), (Throwable)cex);
                        this.getStatusHandler().reportError((IStatus)errorStatus);
                        this.getLog().log(4, "ws_ant", 5092, (Object)this, "getMappingExtensions", (Object)EnvironmentMessages.bind((String)EnvironmentMessages.MSG_ERROR_ANT_DATA_TRANSFORM, (Object)key, (Object)transform));
                        throw new CoreException((IStatus)errorStatus);
                    }
                    if (transform != null && transform instanceof BeanModifier) {
                        holder = (PropertyDataHolder)dataTable.get(property);
                        if (holder == null) {
                            holder = new PropertyDataHolder();
                            holder.key_ = "";
                            holder.value_ = "";
                            holder.transform_ = transform;
                            holder.operation_ = operation;
                            holder.property_ = property;
                            holder.map_ = new HashMap();
                            holder.map_.put(key, value);
                            dataTable.put(property, holder);
                        } else {
                            holder.map_.put(key, value);
                        }
                    } else {
                        holder = new PropertyDataHolder();
                        holder.operation_ = operation;
                        holder.key_ = key;
                        holder.property_ = property;
                        holder.transform_ = transform;
                        holder.value_ = value;
                        dataTable.put(property, holder);
                    }
                } else if (ce.getAttribute(MAPPER_REQUIRED_ATTRIBUTE) != null && ce.getAttribute(MAPPER_REQUIRED_ATTRIBUTE).equals("true")) {
                    msg = EnvironmentMessages.bind((String)EnvironmentMessages.MSG_ERROR_ANT_REQUIRED_PROPERTY, (Object)key.toString());
                    statusObj = new Status(4, "org.eclipse.wst.command.env", 4, msg, null);
                    this.getStatusHandler().reportError((IStatus)statusObj);
                    this.getLog().log(4, "ws_ant", 9999, (Object)this, "getMappingExtensions", (Object)msg);
                } else if (this.verbose()) {
                    msg = EnvironmentMessages.bind((String)EnvironmentMessages.MSG_INFO_ANT__PROPERTY_DEFAULT, (Object)key.toString());
                    statusObj = new Status(1, "org.eclipse.wst.command.env", 1, msg, null);
                    this.getStatusHandler().reportInfo((IStatus)statusObj);
                    this.getLog().log(1, "ws_ant", 9999, (Object)this, "getMappingExtensions", (Object)msg);
                }
            }
            ++i;
        }
        return dataTable.elements();
    }

    private boolean transformAndSet(PropertyDataHolder mapping, String setterMethodName) {
        Object transform = mapping.transform_;
        if (transform != null) {
            try {
                Object param = new Object();
                if (transform instanceof Transformer) {
                    Transformer transformer = (Transformer)transform;
                    param = transformer.transform((Object)mapping.value_);
                } else if (mapping.map_ != null && transform instanceof BeanModifier) {
                    BeanModifier modifier = (BeanModifier)transform;
                    Method getter = this.getGetterMethod(mapping);
                    param = getter.invoke((Object)mapping.operation_, new Object[0]);
                    modifier.modify(param, (Object)mapping.map_);
                }
                return this.callSetter(mapping.operation_, param, setterMethodName);
            }
            catch (Exception exc) {
                this.getStatusHandler().reportError((IStatus)new Status(4, "ws_ant", 5093, exc.getMessage(), (Throwable)exc));
                this.getLog().log(4, "ws_ant", 5093, (Object)this, "transformAndSet", (Object)EnvironmentMessages.bind((String)EnvironmentMessages.MSG_ERROR_ANT_DATA_TRANSFORM, (Object)mapping.key_, (Object)mapping.transform_));
                throw new IllegalArgumentException(exc.getMessage());
            }
        }
        return false;
    }

    private Vector getSetterList(Object op) {
        Vector<Method> result = new Vector<Method>();
        Method[] methods = op.getClass().getMethods();
        int index = 0;
        while (index < methods.length) {
            Method method = methods[index];
            boolean isPublic = Modifier.isPublic(method.getModifiers());
            Class<?> returnType = method.getReturnType();
            if (isPublic && returnType == Void.TYPE && method.getParameterTypes().length == 1 && method.getName().startsWith("set")) {
                method.setAccessible(true);
                result.add(method);
            }
            ++index;
        }
        return result;
    }

    private Method getGetterMethod(PropertyDataHolder mapping) {
        Method getterFound = null;
        if (this.classEntry.getterList_ == null) {
            this.classEntry.getterList_ = this.getGetterList(mapping.operation_);
        }
        int index = 0;
        while (index < this.classEntry.getterList_.size()) {
            Method getter = (Method)this.classEntry.getterList_.elementAt(index);
            if (getter.getName().equals("get" + mapping.property_)) {
                getterFound = getter;
                break;
            }
            ++index;
        }
        return getterFound;
    }

    private Vector getGetterList(Object object) {
        Vector<Method> result = new Vector<Method>();
        Method[] methods = object.getClass().getMethods();
        int index = 0;
        while (index < methods.length) {
            Method method = methods[index];
            boolean isPublic = Modifier.isPublic(method.getModifiers());
            Class<?> returnType = method.getReturnType();
            if (isPublic && returnType != Void.TYPE && method.getParameterTypes().length == 0 && method.getName().startsWith("get")) {
                method.setAccessible(true);
                result.add(method);
            }
            ++index;
        }
        return result;
    }

    private boolean callSetter(AbstractDataModelOperation op, Object param, String setterMethodName) throws CoreException {
        Iterator iterator = this.classEntry.setterList_.iterator();
        while (iterator.hasNext()) {
            Class<?>[] paramTypes;
            Method method = (Method)iterator.next();
            if (!method.getName().equals(setterMethodName) || (paramTypes = method.getParameterTypes()).length != 1 || param == null) continue;
            try {
                method.invoke((Object)op, param);
                return true;
            }
            catch (Exception cex) {
                Status errorStatus = new Status(4, "ws_ant", 5094, cex.getMessage(), (Throwable)cex);
                this.getStatusHandler().reportError((IStatus)errorStatus);
                this.getLog().log(4, "ws_ant", 5094, (Object)this, "callSetter", (Object)EnvironmentMessages.bind((String)EnvironmentMessages.MSG_ERROR_ANT_CALL_SETTER, (Object)setterMethodName));
                throw new CoreException((IStatus)errorStatus);
            }
        }
        return false;
    }

    private boolean callPrimitiveSetter(PropertyDataHolder mapping) throws CoreException {
        Iterator iterator = this.classEntry.setterList_.iterator();
        while (iterator.hasNext()) {
            Method element = (Method)iterator.next();
            Class<?>[] parmTypes = element.getParameterTypes();
            if (parmTypes.length != 1 || !parmTypes[0].isPrimitive()) continue;
            Class<?> parmType = parmTypes[0].getClass();
            Constable setterParm = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (parmType.equals(clazz)) {
                setterParm = Integer.valueOf(mapping.value_);
            } else {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (parmType.equals(clazz2)) {
                    setterParm = Boolean.valueOf(mapping.value_);
                } else {
                    Class<?> clazz3 = class$2;
                    if (clazz3 == null) {
                        try {
                            clazz3 = Class.forName("java.lang.Character");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (parmType.equals(clazz3) && mapping.value_.length() == 1) {
                        setterParm = new Character(mapping.value_.charAt(0));
                    } else {
                        Class<?> clazz4 = class$3;
                        if (clazz4 == null) {
                            try {
                                clazz4 = Class.forName("java.lang.Byte");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (parmType.equals(clazz4)) {
                            setterParm = Byte.valueOf(mapping.value_);
                        } else {
                            Class<?> clazz5 = class$4;
                            if (clazz5 == null) {
                                try {
                                    clazz5 = Class.forName("java.lang.Short");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (parmType.equals(clazz5)) {
                                setterParm = Short.valueOf(mapping.value_);
                            } else {
                                Class<?> clazz6 = class$5;
                                if (clazz6 == null) {
                                    try {
                                        clazz6 = Class.forName("java.lang.Long");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (parmType.equals(clazz6)) {
                                    setterParm = Long.valueOf(mapping.value_);
                                } else {
                                    Class<?> clazz7 = class$6;
                                    if (clazz7 == null) {
                                        try {
                                            clazz7 = Class.forName("java.lang.Float");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (parmType.equals(clazz7)) {
                                        setterParm = Float.valueOf(mapping.value_);
                                    } else {
                                        Class<?> clazz8 = class$7;
                                        if (clazz8 == null) {
                                            try {
                                                clazz8 = Class.forName("java.lang.Double");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (parmType.equals(clazz8)) {
                                            setterParm = Double.valueOf(mapping.value_);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (setterParm == null) continue;
            try {
                element.invoke((Object)mapping.operation_, setterParm);
                return true;
            }
            catch (Exception e) {
                Status errorStatus = new Status(4, "ws_ant", 5095, e.getMessage(), (Throwable)e);
                this.getStatusHandler().reportError((IStatus)errorStatus);
                this.getLog().log(4, "ws_ant", 5095, (Object)this, "callPrimitiveSetter", (Object)EnvironmentMessages.bind((String)EnvironmentMessages.MSG_ERROR_ANT_CALL_SETTER, (Object)element.getName()));
                throw new CoreException((IStatus)errorStatus);
            }
        }
        return false;
    }

    private boolean callSetterConstructor(PropertyDataHolder mapping) throws CoreException {
        Iterator iterator = this.classEntry.setterList_.iterator();
        while (iterator.hasNext()) {
            Method element = (Method)iterator.next();
            Class<?>[] parmTypes = element.getParameterTypes();
            Class[] classArray = new Class[1];
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] stringParm = classArray;
            if (parmTypes.length != 1) continue;
            try {
                Constructor<?> ctor = parmTypes.getClass().getConstructor(stringParm);
                Object parameter = ctor.newInstance(mapping.value_);
                element.invoke((Object)mapping.operation_, parameter);
            }
            catch (Exception exc) {
                Status errorStatus = new Status(4, "ws_ant", 5096, exc.getMessage(), (Throwable)exc);
                this.getStatusHandler().reportError((IStatus)errorStatus);
                this.getLog().log(4, "ws_ant", 5096, (Object)this, "callSetterConstructor", (Object)EnvironmentMessages.bind((String)EnvironmentMessages.MSG_ERROR_ANT_CALL_SETTER, (Object)element.getName()));
                throw new CoreException((IStatus)errorStatus);
            }
        }
        return false;
    }

    public CommandManager getCommandManager() {
        return this.controller_.getOperationManager();
    }

    public CommandFragment getRootCommandFragment() {
        String scenarioProperty = this.getProperty(SCENARIO_TYPE_PROPERTY);
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint extPt = reg.getExtensionPoint(EXT_PT_NAMESPACE, SCENARIO_EXT_PT);
        IConfigurationElement[] elements = extPt.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement configElement = elements[i];
            if (configElement.getAttribute(SCENARIO_TYPE_ATTRIBUTE).equals(scenarioProperty)) {
                try {
                    Object obj = configElement.createExecutableExtension(SCENARIO_CLASS_ATTRIBUTE);
                    if (obj instanceof CommandFragment) {
                        return (CommandFragment)obj;
                    }
                }
                catch (Exception exception) {
                    Status errorStatus = new Status(4, "ws_ant", 5097, exception.getMessage(), (Throwable)exception);
                    this.getStatusHandler().reportError((IStatus)errorStatus);
                    this.getLog().log(4, "ws_ant", 5097, (Object)this, "getRootCommandFragment", (Object)EnvironmentMessages.MSG_ERROR_ANT_CMD_FRAGMENT);
                }
            }
            ++i;
        }
        return null;
    }
}

