/**
 * <copyright>
 *
 * Copyright (c) 2003-2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: SetSDODefaultsAction.java,v 1.5 2006/12/29 18:26:00 marcelop Exp $
 */
package org.eclipse.emf.ecore.sdo.action;


import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.presentation.SDOEditorPlugin;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;


/**
 * 
 */
public class SetSDODefaultsAction 
  extends ActionDelegate
  implements IActionDelegate
{
  protected static final URI PLATFORM_RESOURCE = URI.createPlatformResourceURI("/", false);

  protected GenModel genModel;

  public SetSDODefaultsAction()
  {
    super();
  }

  @Override
  public void run(IAction action)
  {
    EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(genModel);
    if (editingDomain != null)
    {
      CompoundCommand compoundCommand = new CompoundCommand(0, SDOEditorPlugin.INSTANCE.getString("_UI_SetSDODefaults_menu_item"));
      compoundCommand.
        append 
          (SetCommand.create
            (editingDomain, 
             genModel, 
             GenModelPackage.eINSTANCE.getGenModel_RootExtendsInterface(), 
             ""));
      compoundCommand.
        append 
          (SetCommand.create
            (editingDomain, 
             genModel, 
             GenModelPackage.eINSTANCE.getGenModel_RootImplementsInterface(), 
             "org.eclipse.emf.ecore.sdo.InternalEDataObject"));
      compoundCommand.
        append 
          (SetCommand.create
            (editingDomain, 
             genModel, 
             GenModelPackage.eINSTANCE.getGenModel_RootExtendsClass(), 
             "org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl"));
      compoundCommand.
        append 
          (SetCommand.create
            (editingDomain, 
             genModel, 
             GenModelPackage.eINSTANCE.getGenModel_FeatureMapWrapperInterface(), 
             "commonj.sdo.Sequence"));
      compoundCommand.
        append 
          (SetCommand.create
            (editingDomain, 
             genModel, 
             GenModelPackage.eINSTANCE.getGenModel_FeatureMapWrapperInternalInterface(), 
             "org.eclipse.emf.ecore.sdo.util.ESequence"));
      compoundCommand.
        append 
          (SetCommand.create
            (editingDomain, 
             genModel, 
             GenModelPackage.eINSTANCE.getGenModel_FeatureMapWrapperClass(), 
             "org.eclipse.emf.ecore.sdo.util.BasicESequence"));
      compoundCommand.
        append 
          (SetCommand.create
            (editingDomain, 
             genModel, 
             GenModelPackage.eINSTANCE.getGenModel_SuppressEMFTypes(), 
             Boolean.TRUE));
      compoundCommand.
        append 
          (SetCommand.create
            (editingDomain, 
             genModel, 
             GenModelPackage.eINSTANCE.getGenModel_SuppressEMFMetaData(), 
             Boolean.TRUE));
      
      List<String> modelPluginVariableAdditions = new ArrayList<String>();
      modelPluginVariableAdditions.add("EMF_COMMONJ_SDO=org.eclipse.emf.commonj.sdo");
      modelPluginVariableAdditions.add("EMF_ECORE_SDO=org.eclipse.emf.ecore.sdo");
      modelPluginVariableAdditions.removeAll(genModel.getModelPluginVariables());
      if (!modelPluginVariableAdditions.isEmpty())
      {
        compoundCommand.
          append 
            (new AddCommand
              (editingDomain, 
               genModel, 
               GenModelPackage.eINSTANCE.getGenModel_ModelPluginVariables(), 
               modelPluginVariableAdditions));
      }

      List<String> staticPackageURIAdditions = new ArrayList<String>();
      staticPackageURIAdditions.add(SDOPackage.eNS_URI);
      staticPackageURIAdditions.removeAll(genModel.getStaticPackages());
      if (!staticPackageURIAdditions.isEmpty())
      {
        compoundCommand.
          append 
            (new AddCommand
              (editingDomain, 
               genModel, 
               GenModelPackage.eINSTANCE.getGenModel_StaticPackages(), 
               staticPackageURIAdditions));
      }

      editingDomain.getCommandStack().execute(compoundCommand);
    }
  }

  @Override
  public void selectionChanged(IAction action, ISelection selection) 
  {
    if (selection instanceof IStructuredSelection)
    {
      Object object = ((IStructuredSelection)selection).getFirstElement();
      if (object instanceof GenModel)
      {
        genModel = (GenModel)object;

        action.setEnabled(true);
        return;
      }
    }
    genModel = null;
    action.setEnabled(false);
  }
}
