/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.stp.b2j.core.jengine.internal.core.Runner;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;

public class WSIFJavaPort {
    public Object portImpl;

    public WSIFJavaPort(String clazz) throws Exception {
        Thread t;
        if (clazz == null) {
            throw new ClassNotFoundException("(null class string)");
        }
        if (clazz.length() == 0) {
            throw new ClassNotFoundException("(empty class string - zero length)");
        }
        try {
            this.portImpl = Class.forName(clazz).newInstance();
        }
        catch (Exception exception) {}
        if (this.portImpl == null && (t = Thread.currentThread()) instanceof Runner) {
            try {
                this.portImpl = ((Runner)t).getProgramClassLoader().loadClass(clazz).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException("(could not load Java class to implement WSIF port - " + e.getMessage() + ")", e);
            }
        }
        System.out.println("NEW JAVA PORT " + clazz);
    }

    public Object getPortImplementation() {
        return this.portImpl;
    }

    public Object invoke(String methodName, Object[] args) throws Exception {
        Method method = null;
        boolean matchedName = false;
        boolean matchedLen = false;
        Class<?> clazz = this.portImpl.getClass();
        while (clazz != null && method == null) {
            Method[] methods = clazz.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                String mname = methods[i].getName();
                if (mname.equals(methodName)) {
                    matchedName = true;
                    Class<?>[] argtypes = methods[i].getParameterTypes();
                    if (argtypes.length == args.length) {
                        matchedLen = true;
                        method = methods[i];
                        int k = 0;
                        while (k < argtypes.length && method != null) {
                            if (!(argtypes[k].isAssignableFrom(args[k].getClass()) || args[k] instanceof Number && argtypes[k].isPrimitive() || args[k] instanceof Boolean && argtypes[k].isPrimitive())) {
                                method = null;
                            }
                            ++k;
                        }
                    }
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            try {
                return method.invoke(this.portImpl, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof Exception) {
                    throw (Exception)e.getTargetException();
                }
                throw new Exception("(Exception wrapped throwable) " + Logger.getStackTrace(e.getTargetException()));
            }
        }
        if (matchedName && matchedLen) {
            throw new Exception("Could not find method " + methodName + " variant with appropriate argument types");
        }
        if (matchedName) {
            throw new Exception("Could not find method " + methodName + " variant with " + args.length + " arguments");
        }
        throw new Exception("Could not find method with name " + methodName + " in class " + this.portImpl.getClass().getName());
    }
}

