/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf.generators;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.CXFUtil;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.LaunchUtil;
import org.eclipse.stp.sc.cxf.launchers.JavaLaunchConfig;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaGenerator;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.stp.sc.jaxws.wsdl.WsdlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CeltixWsdlToJavaGenerator
implements IWsdlToJavaGenerator {
    private static final String INTERFACE_SUFFIX = "Port";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CeltixWsdlToJavaGenerator.class);
    private Hashtable toolParams = new Hashtable();
    private String pojoClass = null;
    private String seiClass = null;
    private String portTypeName = null;
    private boolean genServer = false;
    private boolean genClient = false;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Hashtable) {
            this.toolParams = (Hashtable)data;
        }
    }

    public void run(IPath path, IProject project) throws CoreException {
        try {
            String url = path.toFile().toURL().toExternalForm();
            this.run(url, project);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e);
        }
    }

    public void run(String url, IProject project) throws CoreException {
        try {
            String soapOps;
            ArrayList bindingParams;
            IJavaProject javaProject = JDTUtils.findJavaProject((String)project.getName());
            ArrayList<String> args = new ArrayList<String>();
            args.add("-fe");
            args.add("jaxws");
            args.add("-db");
            args.add("jaxb");
            String outDir = (String)this.toolParams.get("GEN_OUTPUTDIR");
            LOG.debug((Object)("Wsdl to Java output dir: " + outDir));
            File file = new File(outDir);
            if (!file.exists()) {
                file.mkdirs();
            }
            args.add("-d");
            args.add(outDir);
            Map specificParams = (Map)this.toolParams.get("TOOL_SPECIFIC_OPS");
            String genOps = (String)specificParams.get("-impl");
            if (genOps != null) {
                LOG.debug((Object)"The impl option has been set");
                args.add("-impl");
            }
            if ((genOps = (String)specificParams.get("-server")) != null) {
                this.genServer = true;
                LOG.debug((Object)"The server option has been set");
                if (!args.contains("-impl")) {
                    args.add("-impl");
                }
                args.add("-server");
            }
            if ((genOps = (String)specificParams.get("-client")) != null) {
                this.genClient = true;
                LOG.debug((Object)"The client option has been set");
                args.add("-client");
            }
            if ((bindingParams = (ArrayList)specificParams.get("KEY_BINDING_FILE_LIST")) != null) {
                for (Object bf : bindingParams) {
                    LOG.debug((Object)("BINDing files: " + bf));
                }
            }
            if ((soapOps = (String)specificParams.get("-exsh")) != null) {
                LOG.debug((Object)"Extra soap header option selected");
                args.add("-exsh");
                args.add("true");
            } else {
                args.add("-exsh");
                args.add("false");
            }
            soapOps = (String)specificParams.get("-dns");
            if (soapOps != null) {
                LOG.debug((Object)"default namespace option selected");
                args.add("-dns");
                args.add("true");
            } else {
                args.add("-dns");
                args.add("false");
            }
            soapOps = (String)specificParams.get("-dex");
            if (soapOps != null) {
                LOG.debug((Object)"default  default excludes option selected");
                args.add("-dex");
                args.add("true");
            } else {
                args.add("-dex");
                args.add("false");
            }
            String miscOps = (String)specificParams.get("-ant");
            if (miscOps != null) {
                LOG.debug((Object)"The ant option has been set");
                args.add("-ant");
            }
            if ((miscOps = (String)specificParams.get("-verbose")) != null) {
                LOG.debug((Object)"The verbose option has been set");
                args.add("-verbose");
            }
            this.processWsdlProperty(url, project);
            this.processLaunchConfig(url, project);
            if (this.pojoClass != null) {
                this.processPojoCustomize(url, this.pojoClass, args);
            } else if (this.seiClass != null) {
                this.processSEICustomize(url, this.seiClass, args);
            }
            args.add(url);
            LaunchUtil.launchJavaProgram((IJavaProject)javaProject, (String)"org.apache.cxf.tools.wsdlto.WSDLToJava", null, (String[])args.toArray(new String[0]), null);
            project.refreshLocal(2, null);
        }
        catch (Exception e) {
            LOG.error((Object)"wsdl to java generation error", (Throwable)e);
        }
    }

    private void processLaunchConfig(String wsdlName, IProject project) throws Exception {
        Definition wsdlDef = WsdlUtils.readWSDL((String)wsdlName);
        for (Service s : wsdlDef.getServices().values()) {
            for (Port port : s.getPorts().values()) {
                this.processOnePort(port, project, wsdlName);
            }
        }
    }

    private void processOnePort(Port port, IProject project, String wsdlName) {
        PortType portType = port.getBinding().getPortType();
        this.portTypeName = portType.getQName().getLocalPart();
        String packageName = CXFUtil.getPackageName((String)portType.getQName().getNamespaceURI());
        String seiClsName = String.valueOf(packageName) + "." + portType.getQName().getLocalPart();
        if (this.pojoClass != null) {
            packageName = this.getPackageNameFromCls(this.pojoClass);
            seiClsName = this.getSEINameFromPojo(this.pojoClass);
        } else if (this.seiClass != null) {
            packageName = this.getPackageNameFromCls(this.seiClass);
            seiClsName = this.seiClass;
        }
        this.createLaunchConfig(this.genServer, this.genClient, this.getSimpleName(seiClsName), packageName, wsdlName, port.getName(), project);
    }

    private void processWsdlProperty(String wsdlUrl, IProject project) throws Exception {
        this.pojoClass = null;
        this.seiClass = null;
        String prjLoc = project.getLocation().toOSString();
        if (wsdlUrl.indexOf(prjLoc) < 0) {
            return;
        }
        String relativePath = wsdlUrl.substring(project.getLocation().toOSString().length(), wsdlUrl.length());
        IFile wsdlFile = project.getFile(relativePath);
        if (!wsdlFile.exists()) {
            return;
        }
        this.pojoClass = wsdlFile.getPersistentProperty(JaxWsWorkspaceManager.CLASS_PROPERTY);
        this.seiClass = wsdlFile.getPersistentProperty(JaxWsWorkspaceManager.INTERFACE_PROPERTY);
    }

    private void createLaunchConfig(boolean genServer, boolean genClient, String seiClassName, String packageName, String wsdlName, String portName, IProject project) {
        if (genServer) {
            String args = "\"" + wsdlName + "\"";
            this.createClientLaunchConfiguration(String.valueOf(seiClassName) + "_" + portName + "_Client", packageName, args, project);
        }
        if (genClient) {
            this.createServerLaunchConfiguration(String.valueOf(seiClassName) + "_" + portName + "_Server", packageName, null, project);
        }
    }

    private void processSEICustomize(String wsdlUrl, String sei, ArrayList<String> argsMap) throws Exception {
        String seiName;
        String pkgMapping = this.getCustomizePackage(sei, wsdlUrl);
        if (pkgMapping != null) {
            argsMap.add("-p");
            argsMap.add(pkgMapping);
        }
        if (!(seiName = this.getSimpleName(sei)).equals(this.portTypeName)) {
            String bindingFile = this.createBindingFile(wsdlUrl, seiName, null);
            argsMap.add("-b");
            argsMap.add(bindingFile);
        }
    }

    private String getSimpleName(String clsName) {
        if (clsName.indexOf(".") >= 0) {
            return clsName.substring(clsName.lastIndexOf(".") + 1);
        }
        return clsName;
    }

    private String getCustomizePackage(String cls, String wsdlUrl) throws Exception {
        String pkgName = this.getPackageNameFromCls(cls);
        String namespace = this.getNamespaceFromWsdl(wsdlUrl);
        String wsdlPkgName = null;
        if (namespace != null) {
            wsdlPkgName = CXFUtil.getPackageName((String)namespace);
        }
        if (pkgName != null && wsdlPkgName != null && !pkgName.equals(wsdlPkgName)) {
            LOG.debug((Object)("sei package is:" + pkgName));
            LOG.debug((Object)("wsdl namespace-> package is:" + wsdlPkgName));
            String mapping = String.valueOf(namespace) + "=" + pkgName;
            LOG.debug((Object)("need to set ns->package mapping:" + mapping));
            return mapping;
        }
        return null;
    }

    private String getPackageNameFromCls(String cls) {
        if (cls.indexOf(".") >= 0) {
            return cls.substring(0, cls.lastIndexOf("."));
        }
        return null;
    }

    private String getNamespaceFromWsdl(String wsdlUrl) throws Exception {
        Definition wsdlDef = WsdlUtils.readWSDL((String)wsdlUrl);
        Iterator iPortTypes = wsdlDef.getPortTypes().keySet().iterator();
        if (iPortTypes.hasNext()) {
            QName portType = (QName)iPortTypes.next();
            return portType.getNamespaceURI();
        }
        return null;
    }

    private void processPojoCustomize(String wsdlUrl, String pojo, ArrayList<String> argsMap) {
        try {
            String pkgMapping = this.getCustomizePackage(pojo, wsdlUrl);
            if (pkgMapping != null) {
                argsMap.add("-p");
                argsMap.add(pkgMapping);
            }
            String bindingFile = this.createBindingFile(wsdlUrl, this.getSEINameFromPojo(this.pojoClass), null);
            argsMap.remove("-impl");
            argsMap.add("-b");
            argsMap.add(bindingFile);
        }
        catch (Exception e) {
            LOG.error((Object)"error during generate customized binding file", (Throwable)e);
        }
    }

    public String getSEINameFromPojo(String pojo) {
        String implName = "impl";
        if (pojo.endsWith(implName)) {
            return pojo.substring(0, pojo.length() - implName.length());
        }
        return String.valueOf(pojo) + INTERFACE_SUFFIX;
    }

    private String createBindingFile(String wsdlUrl, String portTypeClass, String packageName) {
        try {
            String line;
            if (portTypeClass != null && portTypeClass.indexOf(".") >= 0) {
                portTypeClass = this.getSimpleName(portTypeClass);
            }
            String wsdlUri = new File(wsdlUrl).toURI().toString();
            File bindingFile = File.createTempFile("binding", "xml");
            PrintWriter pw = new PrintWriter(bindingFile);
            pw.println("<bindings");
            pw.println("    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
            pw.println("    xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"");
            pw.println("    xmlns=\"http://java.sun.com/xml/ns/jaxws\"");
            pw.println("    wsdlLocation=\"" + wsdlUri + "\">");
            if (packageName != null) {
                pw.println("     <package name=\"" + packageName + "\"/>");
            }
            if (portTypeClass != null) {
                pw.println("     <bindings node=\"wsdl:definitions/wsdl:portType\">");
                pw.println("         <class name=\"" + portTypeClass + "\"/>");
                pw.println("     </bindings>");
            }
            pw.println("</bindings>");
            pw.close();
            bindingFile.deleteOnExit();
            BufferedReader br = new BufferedReader(new FileReader(bindingFile));
            LOG.debug((Object)"customized binding file************");
            while ((line = br.readLine()) != null) {
                LOG.debug((Object)line);
            }
            br.close();
            LOG.debug((Object)"customized binding file end*******");
            return bindingFile.toURL().toExternalForm();
        }
        catch (Exception e) {
            LOG.error((Object)"error during create customized binding file", (Throwable)e);
            return null;
        }
    }

    private void createClientLaunchConfiguration(String clientName, String packageName, String progArgs, IProject project) {
        String projectName = project.getName();
        JavaLaunchConfig launchConfig = new JavaLaunchConfig();
        launchConfig.setProgramArgs(progArgs);
        launchConfig.setConfigBaseName(clientName);
        launchConfig.setProjectName(projectName);
        launchConfig.setClientMainClassName(String.valueOf(packageName) + "." + clientName);
        launchConfig.createClientLaunchConfig();
    }

    private void createServerLaunchConfiguration(String serverName, String packageName, String progArgs, IProject project) {
        String projectName = project.getName();
        JavaLaunchConfig launchConfig = new JavaLaunchConfig();
        launchConfig.setProgramArgs(progArgs);
        launchConfig.setConfigBaseName(serverName);
        launchConfig.setProjectName(projectName);
        launchConfig.setServerMainClassName(String.valueOf(packageName) + "." + serverName);
        launchConfig.createServerLaunchConfig();
    }
}

