/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.cxf.generators.CxfJava2wsGenerator;
import org.eclipse.stp.sc.cxf.generators.ToolConstants;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IAdditionalPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPageContentsChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CxfJava2wsParameterPageContents
implements IAdditionalPageContents {
    private static final String[] DATA_BINDING_OPTIONS = new String[]{"jaxb", "aegis"};
    private static final String[] SOAP_OPTIONS = new String[]{ToolConstants.PROPERTY_VALUE_SOAP11, ToolConstants.PROPERTY_VALUE_SOAP12};
    protected Combo cmbDataBinding;
    protected Combo cmbSoap;
    protected Button btnWsdl;
    protected Button btnServer;
    protected Button btnClient;
    protected Button btnXsdImport;
    protected Button btnVerbose;
    private IProject project;
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CxfJava2wsParameterPageContents.class);

    public IAdditionalPageContents getNextPageContents() {
        return null;
    }

    public Control createContents(Composite parent) {
        GridData gridData = new GridData(1808);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group grpPara = new Group(composite, 0);
        grpPara.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        grpPara.setLayoutData((Object)gridData);
        grpPara.setText("CXF java2ws generator parameters");
        new Label((Composite)grpPara, 0).setText("DataBinding");
        this.cmbDataBinding = new Combo((Composite)grpPara, 8);
        gridData = new GridData(768);
        this.cmbDataBinding.setLayoutData((Object)gridData);
        this.cmbDataBinding.setItems(DATA_BINDING_OPTIONS);
        new Label((Composite)grpPara, 0).setText("SOAP");
        this.cmbSoap = new Combo((Composite)grpPara, 8);
        gridData = new GridData(768);
        this.cmbSoap.setLayoutData((Object)gridData);
        this.cmbSoap.setItems(SOAP_OPTIONS);
        this.btnWsdl = new Button((Composite)grpPara, 32);
        this.btnWsdl.setText("Generate WSDL");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.btnWsdl.setLayoutData((Object)gridData);
        this.btnServer = new Button((Composite)grpPara, 32);
        this.btnServer.setText("Generate Server");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.btnServer.setLayoutData((Object)gridData);
        this.btnClient = new Button((Composite)grpPara, 32);
        this.btnClient.setText("Generate Client");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.btnClient.setLayoutData((Object)gridData);
        this.btnXsdImport = new Button((Composite)grpPara, 32);
        this.btnXsdImport.setText("Create XSD Import");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.btnXsdImport.setLayoutData((Object)gridData);
        this.btnVerbose = new Button((Composite)grpPara, 32);
        this.btnVerbose.setText("Verbose");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.btnVerbose.setLayoutData((Object)gridData);
        this.init();
        return composite;
    }

    public String getDescription() {
        return "Specify java2ws generator parameters.";
    }

    public String getErrorMsg() {
        return null;
    }

    public String getPageName() {
        return "CXF Java2ws Generator Parameter Page";
    }

    public String getTitle() {
        return "CXF Java2ws Generator Parameter Page";
    }

    public boolean isPageValid() {
        return true;
    }

    public void performFinish() {
        try {
            this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_DATA_BINDING, this.cmbDataBinding.getText());
            this.project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_SOAP_OPTION, this.cmbSoap.getText());
            this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL, this.getTrueOrFalse(this.btnWsdl.getSelection()));
            this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER, this.getTrueOrFalse(this.btnServer.getSelection()));
            this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT, this.getTrueOrFalse(this.btnClient.getSelection()));
            this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_XSD_IMPORT, this.getTrueOrFalse(this.btnXsdImport.getSelection()));
            this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_VERBOSE, this.getTrueOrFalse(this.btnVerbose.getSelection()));
            this.project.build(10, null);
            CxfJava2wsGenerator.getInstance().run(this.project);
        }
        catch (Exception ex) {
            LOG.error((Object)"error during setting java2ws parameters", (Throwable)ex);
        }
    }

    public void setChangeListener(IPageContentsChangeListener listener) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    protected void init() {
        if (this.project == null) {
            this.cmbDataBinding.setText(DATA_BINDING_OPTIONS[0]);
            this.cmbSoap.setText(SOAP_OPTIONS[0]);
            this.btnWsdl.setSelection(true);
            this.btnServer.setSelection(true);
            this.btnClient.setSelection(true);
            this.btnXsdImport.setSelection(false);
            this.btnVerbose.setSelection(false);
        } else {
            try {
                this.cmbDataBinding.setText(this.project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_DATA_BINDING));
                this.cmbSoap.setText(this.project.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_SOAP_OPTION));
                this.btnWsdl.setSelection(this.getTrueOrFalse(this.project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL)));
                this.btnServer.setSelection(this.getTrueOrFalse(this.project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER)));
                this.btnClient.setSelection(this.getTrueOrFalse(this.project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT)));
                this.btnXsdImport.setSelection(this.getTrueOrFalse(this.project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_XSD_IMPORT)));
                this.btnVerbose.setSelection(this.getTrueOrFalse(this.project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_VERBOSE)));
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        }
        this.cmbDataBinding.setEnabled(false);
    }

    private boolean getTrueOrFalse(String arg) {
        boolean returnValue = false;
        if (arg != null && arg.trim().equalsIgnoreCase("true")) {
            returnValue = true;
        }
        return returnValue;
    }

    private String getTrueOrFalse(boolean arg) {
        if (arg) {
            return "true";
        }
        return "false";
    }
}

