/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPException;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPNotFoundException;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPResponse;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPServerListener;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPUtils;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.PortServer;

public class HTTPServer {
    static HashMap url_listeners = new HashMap();
    static Object listeners_LOCK = new Object();
    static HashMap pool = new HashMap();
    static Object pool_LOCK = new Object();
    private static final String RECEIVE_PREFIX = "RECEIVE:";
    private static final String REPLY_PREFIX = "REPLY:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PortServer getOrCreatePortServer(String protocol, int port) throws Exception {
        PortServer server;
        Integer oport = new Integer(port);
        Object object = pool_LOCK;
        synchronized (object) {
            server = (PortServer)pool.get(oport);
            if (server == null) {
                server = new PortServer(protocol, port);
                pool.put(oport, server);
            }
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getOrCreateListenersAt(int port, String resource) {
        String key = String.valueOf(port) + " : " + resource;
        ArrayList listeners = null;
        Object object = listeners_LOCK;
        synchronized (object) {
            listeners = (ArrayList)url_listeners.get(key);
            if (listeners == null) {
                listeners = new ArrayList();
                url_listeners.put(key, listeners);
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHttpListener(URL url, HTTPServerListener listener) throws Exception {
        ArrayList listeners;
        String resource;
        int port = url.getPort();
        if (port == -1) {
            try {
                port = HTTPUtils.getDefaultPort(url);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                port = url.getProtocol().equalsIgnoreCase("http") ? 80 : (url.getProtocol().equalsIgnoreCase("https") ? 443 : 80);
            }
        }
        if ((resource = url.getFile()).length() == 0) {
            resource = "/";
        }
        HTTPServer.getOrCreatePortServer(url.getProtocol(), port);
        ArrayList arrayList = listeners = HTTPServer.getOrCreateListenersAt(port, resource);
        synchronized (arrayList) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHttpListener(URL url, HTTPServerListener listener) throws Exception {
        ArrayList listeners;
        int port = url.getPort();
        if (port == -1) {
            try {
                port = HTTPUtils.getDefaultPort(url);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                port = url.getProtocol().equalsIgnoreCase("http") ? 80 : (url.getProtocol().equalsIgnoreCase("https") ? 443 : 80);
            }
        }
        String resource = url.getFile();
        HTTPServer.getOrCreatePortServer(url.getProtocol(), port);
        ArrayList arrayList = listeners = HTTPServer.getOrCreateListenersAt(port, resource);
        synchronized (arrayList) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HTTPResponse doRequest(int port, String resource, String payload, HashMap lc_headers) throws HTTPException {
        ArrayList listeners = HTTPServer.getOrCreateListenersAt(port, resource);
        int i = 0;
        while (i < listeners.size()) {
            HTTPServerListener listener = null;
            ArrayList arrayList = listeners;
            synchronized (arrayList) {
                if (i >= listeners.size()) {
                    throw new HTTPNotFoundException("Resource not found");
                }
                listener = (HTTPServerListener)listeners.get(i);
            }
            try {
                if (listener != null) {
                    // empty if block
                }
                HTTPResponse resp = listener.doRequest(port, resource, payload, lc_headers);
                return resp;
            }
            catch (HTTPNotFoundException hTTPNotFoundException) {
                ++i;
            }
        }
        throw new HTTPNotFoundException("Resource not found");
    }
}

