/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi.transport.session;

import java.io.Serializable;
import org.eclipse.stp.b2j.core.misc.internal.HexData;
import org.eclipse.stp.b2j.core.misc.internal.XMLUtil;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;

public class SessionAddress
implements Cloneable,
Serializable {
    public static final int TRANSPORT_PORT_ANY = -1;
    private String transport_provider_class = "";
    private boolean requires_multiple_streams = false;
    private boolean requires_encryption = false;
    private boolean requires_link_reconnection = false;
    private int requires_encryption_bits = 128;
    private boolean requires_multiple_connections = false;
    private boolean requires_authentication = false;
    private long abort_timeout_ms = 120000L;
    private long startup_abort_timeout_ms = 60000L;
    private String initiator_host = "";
    private int initiator_port_min = 0;
    private int initiator_port_max = 0;
    private String listener_host = "";
    private int listener_port_min = 0;
    private int listener_port_max = 0;
    private String password = "";
    private boolean requires_password = false;

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getRequiresPassword() {
        return this.requires_password;
    }

    public void setRequiresPassword(boolean b) {
        this.requires_password = b;
    }

    public void setRequiresMultipleStreams(boolean b) {
        this.requires_multiple_streams = b;
    }

    public boolean getRequiresMultipleStreams() {
        return this.requires_multiple_streams;
    }

    public void setRequiresMultipleConnections(boolean b) {
        this.requires_multiple_connections = b;
    }

    public boolean getRequiresMultipleConnections() {
        return this.requires_multiple_connections;
    }

    public void setRequiresEncryption(boolean b) {
        this.requires_encryption = b;
    }

    public boolean getRequiresEncryption() {
        return this.requires_encryption;
    }

    public void setRequiresAuthentication(boolean b) {
        this.requires_authentication = b;
    }

    public boolean getRequiresAuthentication() {
        return this.requires_authentication;
    }

    public void setRequiresEncryptionStrengthBits(int bits) {
        this.requires_encryption_bits = bits;
    }

    public int getRequiresEncryptionStrengthBits() {
        return this.requires_encryption_bits;
    }

    public void setRequiresLinkReconnection(boolean b) {
        this.requires_link_reconnection = b;
    }

    public boolean getRequiresLinkReconnection() {
        return this.requires_link_reconnection;
    }

    public void setReconnectionFailureAbortTimeout(long milliseconds) {
        this.abort_timeout_ms = milliseconds;
    }

    public long getReconnectionFailureAbortTimeout() {
        return this.abort_timeout_ms;
    }

    public void setStartupFailureAbortTimeout(long milliseconds) {
        this.startup_abort_timeout_ms = milliseconds;
    }

    public long getStartupFailureAbortTimeout() {
        return this.startup_abort_timeout_ms;
    }

    public void setTransportProviderClassName(String classname) {
        this.transport_provider_class = classname;
    }

    public String getTransportProviderClassName() {
        return this.transport_provider_class;
    }

    public void setInitiatorHost(String host) {
        this.initiator_host = host;
    }

    public String getInitiatorHost() {
        return this.initiator_host;
    }

    public void setInitiatorPortMinimum(int port) {
        this.initiator_port_min = port;
    }

    public int getInitiatorPortMinimum() {
        return this.initiator_port_min;
    }

    public void setInitiatorPortMaximum(int port) {
        this.initiator_port_max = port;
    }

    public int getInitiatorPortMaximum() {
        return this.initiator_port_max;
    }

    public void setListenerHost(String host) {
        this.listener_host = host;
    }

    public String getListenerHost() {
        return this.listener_host;
    }

    public void setListenerPortMinimum(int port) {
        this.listener_port_min = port;
    }

    public int getListenerPortMinimum() {
        return this.listener_port_min;
    }

    public void setListenerPortMaximum(int port) {
        this.listener_port_max = port;
    }

    public int getListenerPortMaximum() {
        return this.listener_port_max;
    }

    private SessionAddress() {
    }

    public SessionAddress(String from_host, int from_port_min, int from_port_max, String to_host, int to_port_min, int to_port_max) {
        this.initiator_host = from_host;
        this.initiator_port_min = from_port_min;
        this.initiator_port_max = from_port_max;
        this.listener_host = to_host;
        this.listener_port_min = to_port_min;
        this.listener_port_max = to_port_max;
    }

    public static String toString(SessionAddress address) throws Exception {
        Document doc = XMLUtil.blankDocument("SessionAddress");
        Element elem_address = doc.getDocumentElement();
        elem_address.setAttribute("transport_provider_class", address.transport_provider_class);
        elem_address.setAttribute("requires_multiple_streams", "" + address.requires_multiple_streams);
        elem_address.setAttribute("requires_multiple_connections", "" + address.requires_multiple_connections);
        elem_address.setAttribute("requires_encryption", "" + address.requires_encryption);
        elem_address.setAttribute("requires_link_reconnection", "" + address.requires_link_reconnection);
        elem_address.setAttribute("requires_encryption_bits", "" + address.requires_encryption_bits);
        elem_address.setAttribute("requires_authentication", "" + address.requires_authentication);
        elem_address.setAttribute("abort_timeout_ms", "" + address.abort_timeout_ms);
        elem_address.setAttribute("startup_abort_timeout_ms", "" + address.startup_abort_timeout_ms);
        elem_address.setAttribute("initiator_host", address.initiator_host);
        elem_address.setAttribute("initiator_port_min", "" + address.initiator_port_min);
        elem_address.setAttribute("initiator_port_max", "" + address.initiator_port_max);
        elem_address.setAttribute("listener_host", address.listener_host);
        elem_address.setAttribute("listener_port_min", "" + address.listener_port_min);
        elem_address.setAttribute("listener_port_max", "" + address.listener_port_max);
        elem_address.setAttribute("requires_password", "" + address.requires_password);
        if (address.password != null) {
            elem_address.setAttribute("password", HexData.stringToHexString(address.password));
        }
        return XMLUtil.documentToString(elem_address);
    }

    public static SessionAddress fromString(String xml) throws Exception {
        Document doc = XMLUtil.documentFromString(xml);
        Element elem_address = doc.getDocumentElement();
        SessionAddress address = new SessionAddress();
        address.transport_provider_class = elem_address.getAttribute("transport_provider_class");
        address.requires_multiple_streams = elem_address.getAttribute("requires_multiple_streams").equals("true");
        address.requires_multiple_connections = elem_address.getAttribute("requires_multiple_connections").equals("true");
        address.requires_encryption = elem_address.getAttribute("requires_encryption").equals("true");
        address.requires_link_reconnection = elem_address.getAttribute("requires_link_reconnection").equals("true");
        address.requires_encryption_bits = Integer.parseInt(elem_address.getAttribute("requires_encryption_bits"));
        address.requires_authentication = elem_address.getAttribute("requires_authentication").equals("true");
        address.abort_timeout_ms = Long.parseLong(elem_address.getAttribute("abort_timeout_ms"));
        address.startup_abort_timeout_ms = Long.parseLong(elem_address.getAttribute("startup_abort_timeout_ms"));
        address.initiator_host = elem_address.getAttribute("initiator_host");
        address.initiator_port_min = Integer.parseInt(elem_address.getAttribute("initiator_port_min"));
        address.initiator_port_max = Integer.parseInt(elem_address.getAttribute("initiator_port_max"));
        address.listener_host = elem_address.getAttribute("listener_host");
        address.listener_port_min = Integer.parseInt(elem_address.getAttribute("listener_port_min"));
        address.listener_port_max = Integer.parseInt(elem_address.getAttribute("listener_port_max"));
        address.password = elem_address.hasAttribute("password") ? HexData.hexStringToString(elem_address.getAttribute("password")) : null;
        address.requires_password = elem_address.hasAttribute("requires_password") ? elem_address.getAttribute("requires_password").equals("true") : false;
        return address;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        boolean same = true;
        if (o instanceof SessionAddress) {
            SessionAddress addr = (SessionAddress)o;
            if (!addr.initiator_host.equals(this.initiator_host)) {
                same = false;
            }
            if (addr.initiator_port_min != this.initiator_port_min) {
                same = false;
            }
            if (addr.initiator_port_max != this.initiator_port_max) {
                same = false;
            }
            if (!addr.listener_host.equals(this.listener_host)) {
                same = false;
            }
            if (addr.listener_port_min != this.listener_port_min) {
                same = false;
            }
            if (addr.listener_port_max != this.listener_port_max) {
                same = false;
            }
            if (!addr.transport_provider_class.equals(this.transport_provider_class)) {
                same = false;
            }
            if (addr.requires_multiple_streams != this.requires_multiple_streams) {
                same = false;
            }
            if (addr.requires_multiple_connections != this.requires_multiple_connections) {
                same = false;
            }
            if (addr.requires_encryption != this.requires_encryption) {
                same = false;
            }
            if (addr.requires_link_reconnection != this.requires_link_reconnection) {
                same = false;
            }
            if (addr.requires_encryption_bits != this.requires_encryption_bits) {
                same = false;
            }
            if (addr.requires_authentication != this.requires_authentication) {
                same = false;
            }
            if (addr.abort_timeout_ms != this.abort_timeout_ms) {
                same = false;
            }
            if (addr.startup_abort_timeout_ms != this.startup_abort_timeout_ms) {
                same = false;
            }
        } else {
            same = false;
        }
        return same;
    }

    public Object clone() {
        SessionAddress addr = new SessionAddress();
        addr.initiator_host = this.initiator_host;
        addr.initiator_port_min = this.initiator_port_min;
        addr.initiator_port_max = this.initiator_port_max;
        addr.listener_host = this.listener_host;
        addr.listener_port_min = this.listener_port_min;
        addr.listener_port_max = this.listener_port_max;
        addr.transport_provider_class = this.transport_provider_class;
        addr.requires_multiple_streams = this.requires_multiple_streams;
        addr.requires_multiple_connections = this.requires_multiple_connections;
        addr.requires_encryption = this.requires_encryption;
        addr.requires_link_reconnection = this.requires_link_reconnection;
        addr.requires_encryption_bits = this.requires_encryption_bits;
        addr.requires_authentication = this.requires_authentication;
        addr.abort_timeout_ms = this.abort_timeout_ms;
        addr.startup_abort_timeout_ms = this.startup_abort_timeout_ms;
        addr.requires_password = this.requires_password;
        addr.password = this.password;
        return addr;
    }

    private void appendPort(StringBuffer sb, int p) {
        if (p == -1) {
            sb.append("ANY");
        } else {
            sb.append(p);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.initiator_host);
        sb.append(":");
        this.appendPort(sb, this.initiator_port_min);
        sb.append("-");
        this.appendPort(sb, this.initiator_port_max);
        sb.append(" -> ");
        sb.append(this.listener_host);
        sb.append(":");
        this.appendPort(sb, this.listener_port_min);
        sb.append("-");
        this.appendPort(sb, this.listener_port_max);
        if (this.requires_multiple_streams) {
            sb.append(" (daemon)");
        }
        if (this.requires_multiple_streams) {
            sb.append(" (multiplexed)");
        }
        if (this.requires_encryption) {
            sb.append(" (encrypted " + this.requires_encryption_bits + ")");
        }
        if (this.requires_authentication) {
            sb.append(" (authenticated)");
        }
        if (this.requires_link_reconnection) {
            sb.append(" (reconnect " + this.startup_abort_timeout_ms + "ms " + this.abort_timeout_ms + "ms)");
        }
        if (this.transport_provider_class.length() > 0) {
            sb.append(" (transport " + this.transport_provider_class + ")");
        }
        if (this.requires_password) {
            sb.append(" (password)");
        }
        return sb.toString();
    }
}

