package org.eclipes.stp.soas.deploy.runtime.tuscany;

import java.io.File;

import org.eclipes.stp.soas.deploy.runtime.tuscany.core.internal.ITuscanyVersionHandler;
import org.eclipes.stp.soas.deploy.runtime.tuscany.core.internal.Tuscany10VersionHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

/**
 * The activator class controls the plug-in life cycle
 */
public class TuscanyRuntimePlugin extends Plugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.stp.soas.deploy.runtime.tuscanyjava";
	
	public static final String LOCATION_KEY = "location";

	private static final String VERSION_1_0 = ".10";
	// The shared instance
	private static TuscanyRuntimePlugin plugin;
	
	
	
	
	/**
	 * The constructor
	 */
	public TuscanyRuntimePlugin() {
		plugin = this;
	}

	
	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static TuscanyRuntimePlugin getDefault() {
		return plugin;
	}

    	
	public static ITuscanyVersionHandler getVersionHandler(String id) {
		if (id.endsWith(VERSION_1_0)) {
		 	return new Tuscany10VersionHandler();
		}
		return null;
	}
	
	/**
	 * Return the install location preference.
	 * 
	 * @param id a runtime type id
	 * @return the install location
	 */
	public static String getPreference(String id) {
		return "";
		//return getDefault().getPluginPreferences().getString(id);
	}
	
	/**
	 * Set the install location preference.
	 * 
	 * @param id the runtimt type id
	 * @param value the location
	 */
	public static void setPreference(String id, String value) {
		/*
		getDefault().getPluginPreferences().setValue(id, value);
		getDefault().savePluginPreferences();
		*/
	}
	
	
	/**
	 * Verify the tuscany installation directory.
	 * 
	 * @param installPath
	 * @return <code>true</code> if the directory may be a RI installation,
	 *    and <code>false</code> otherwise
	 */
	public static boolean verifyInstallPath(IPath installPath) {
		if (installPath == null)
			return false;
		
		String dir = installPath.toOSString();
		if (!dir.endsWith(File.separator))
			dir += File.separator;

		// look for /lib/tuscany-sca-manifest.jar 
		File manifest = new File(dir + "lib" + File.separator + "tuscany-sca-manifest.jar");
		if (!manifest.exists()) {
			return false;
		}
		return true;
	}
	
}
