/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxwsri.generators;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxwsri.JAXWSRIResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IParameterPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JAXWSRIWsdlToJavaParameterPage implements IParameterPage
{

	public static final String KEY_BINDING_FILE_LIST = "KEY_BINDING_FILE_LIST";
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(JAXWSRIWsdlToJavaParameterPage.class);

	Button btBindingFile = null;
	Text txtBindingFiles = null;
	Button btBrowse = null;
	Button btVerbose = null;
	HashMap<String, Object> params = new HashMap<String, Object>();
	Shell parentShell = null;
	WizardPage hostPage = null;
	String wsdlUrl;

	public Control createContents(Composite parent) {
		parentShell = parent.getShell();
		Composite compBinding = new Composite(parent, SWT.NONE);
		compBinding.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		compBinding.setLayout(new GridLayout(2, false));

		btBindingFile = new Button(compBinding, SWT.CHECK);
		btBindingFile.setText(JAXWSRIResources.getString("Wsdl.To.Java.BindingFile.Checkbox.Text"));
		btBindingFile.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				txtBindingFiles.setEnabled(btBindingFile.getSelection());
				btBrowse.setEnabled(btBindingFile.getSelection());
				validateParams();
			}
		});
		
		new Text(compBinding, SWT.SINGLE | SWT.Hide).setVisible(false);
		
		txtBindingFiles = new Text(compBinding, SWT.SINGLE | SWT.BORDER);
		txtBindingFiles.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		txtBindingFiles.setEnabled(false);
		txtBindingFiles.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				validateParams();
			}
		});
		
		btBrowse = new Button(compBinding, SWT.PUSH);
		btBrowse.setText(JAXWSRIResources.getString("Wsdl.To.Java.Browse.Binding.Button"));
		btBrowse.setEnabled(false);
		btBrowse.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				LOG.debug("Browsing button is pressed");
				FileDialog fileChooser = new FileDialog(parentShell, SWT.OPEN | SWT.MULTI);
				String result = fileChooser.open();
				if (result != null) {
					String[] names = fileChooser.getFileNames();
					String path = fileChooser.getFilterPath();
					StringBuffer sbValue = new StringBuffer();
					for (int i = 0; i < names.length; ++i) {
						sbValue.append(path + names[i]);
						if (i < (names.length - 1)) {
							sbValue.append(", ");
						}
					}
					txtBindingFiles.setText(sbValue.toString());
				}
				validateParams();
			}
		});
		
		Composite compMisc = new Composite(parent, SWT.NONE);
		compMisc.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		compMisc.setLayout(new GridLayout(2, false));

		btVerbose = new Button(compMisc, SWT.CHECK);
		btVerbose.setText(JAXWSRIResources.getString("Wsdl.To.Java.Mist.Verbose.Text"));
		btVerbose.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (btVerbose.getSelection()) {
					params.put(ToolConstants.WSDL2JAVA_PARA_VERBOSE, "");
				} else {
					params.remove(ToolConstants.WSDL2JAVA_PARA_VERBOSE);
				}
				validateParams();
			}			
		});
		
		return parent;
	}

	public Map<String, Object> getParameters() {
		return params;
	}

	public void performOK() {
		if (btBindingFile.getSelection()) {
			String bFileStr = btBindingFile.getText();
			StringTokenizer tkzr = new StringTokenizer(bFileStr, ",");
			ArrayList<String> listFiles = new ArrayList<String>();
			while (tkzr.hasMoreTokens()) {
				String fPath = tkzr.nextToken();
				listFiles.add(fPath);
			}
			params.put(KEY_BINDING_FILE_LIST, listFiles);
		}
	}

	public void setInitializationData(IConfigurationElement config,
			String propertyName, Object data) throws CoreException {
		// TODO Auto-generated method stub

	}

	public String validateParams() {
		String result = null;
		if (btBindingFile.getSelection()) {
			if (this.txtBindingFiles.getText().trim().equals("")) {
				result = JAXWSRIResources.getString("Wsdl.To.Java.Param.Binding.File.Empty");
			} else {
				String bFileStr = txtBindingFiles.getText();
				StringTokenizer tkzr = new StringTokenizer(bFileStr, ",");
				while (tkzr.hasMoreTokens()) {
					String fPath = tkzr.nextToken();
					LOG.debug("File Path: " + fPath);
					File file = new File(fPath);
					if (!file.exists()) {
						result = JAXWSRIResources.getString("Wsdl.To.Java.Param.File.Not.Exist") + fPath;
						break;
					} else {
						if (file.isDirectory()) {
							result = JAXWSRIResources.getString("Wsdl.To.Java.Param.File.Is.Dir") + fPath;
							break;
						}
					}
				}
			}
		}

		hostPage.setErrorMessage(result);
		hostPage.setPageComplete(result == null);
		return result;
	}

	public void setPage(WizardPage page) {
		hostPage = page;
	}
	
	public void setWsdlUrl(String url) {
		LOG.debug("set WsdlURL called:" + url);
	    wsdlUrl = url;	
	}

}
