/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxwsri.wizard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.wizards.AbstractStartingPointPageContents;
import org.eclipse.stp.sc.jaxwsri.JAXWSRIResources;

public class JaxwsriStartingPointPageContents extends AbstractStartingPointPageContents {
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxwsriStartingPointPageContents.class);

	public static final String PAGE_NAME="JAX-WS RI Starting Point Page";
	
	public String validateStartingPoint(String startingPoint) {
		String returnValue = null;
    	StringBuffer buffer = new StringBuffer();
		FileReader reader = null;
		BufferedReader br = null; 
		try{
    		File file = new File(startingPoint);
    		reader = new FileReader(file); 
    		br = new BufferedReader(reader); 
        	String s1 = null;
        	while((s1 = br.readLine()) != null) {
        		buffer.append(s1 + "\n");
        	}
        	char[] charSet = new char[buffer.length()];
        	buffer.getChars(0, buffer.length() -1, charSet, 0);
        	
        	ASTParser parser = ASTParser.newParser(AST.JLS3);
            parser.setSource(charSet);
            org.eclipse.jdt.core.dom.CompilationUnit domCu = (org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST(null);
            List types = domCu.types();
            boolean isValid = false;
            for(int i = 0; i < types.size(); i++){
            	Object type = types.get(i);
            	if(type instanceof TypeDeclaration){
            		if(((TypeDeclaration)type).isInterface()){
            			returnValue = "Interface cannot be set as starting point in JAX-WS RI runtime.";
            			break;
            		}else{
                   		int modifiers = ((TypeDeclaration)type).getModifiers();
                		if(Modifier.isPublic(modifiers)){
                			if(Modifier.isAbstract(modifiers)){
                				returnValue = "Abstract class cannot be set as starting point in JAX-WS RI runtime.";
                			}else{
                				isValid = true;
                			}
                			break;
                		}
            		}
            	}
            }
            if(returnValue == null && !isValid){
            	returnValue = "this is invalid java class file";
            }
		}catch(Exception ex){
			returnValue = "error while validating the starting point file: " + startingPoint;
			LOG.error(returnValue, ex);
		}finally{
    		try{
    			reader.close();
    			br.close();
        		buffer = null;
    		}catch(Exception ex){
    			LOG.error(ex);
    		}
    		
    	}
		return returnValue;
	}

	public String getDescription() {
		return JAXWSRIResources.getString("Wizard.StartingPoint.Page.Description");
	}

	public String getPageName() {
		return PAGE_NAME;
	}

	public String getTitle() {
		return JAXWSRIResources.getString("Wizard.StartingPoint.Page.Title");
	}
}
