/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.wizards.enablejaxws.JavaFirstEnableWizard;
import org.eclipse.stp.sc.jaxws.wizards.enablejaxws.SelectProgramModeDialog;
import org.eclipse.stp.sc.jaxws.wizards.enablejaxws.WsdlFirstEnableWizard;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;


public class EnableScNatureAction implements IWorkbenchWindowActionDelegate {

	public static IAction enableAction = null; 
	
    private static final LoggingProxy LOG = LoggingProxy.getlogger(EnableScNatureAction.class);

    public void dispose() {
        // TODO Auto-generated method stub
    }

    public void init(IWorkbenchWindow window) {
        // TODO Auto-generated method stub
    }

    public void run(IAction action) {

    	try{
        	IProject project = ResourceUtils.getActiveProject();
        	if(project.hasNature(JavaCore.NATURE_ID)){
        		Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        		SelectProgramModeDialog dialog = new SelectProgramModeDialog(shell);
        				
        		int choose = dialog.open();
        		IWizard wizard = null;
        		if(choose == Dialog.OK){
        			if(dialog.getIsJavaFirst()){
        				wizard = new JavaFirstEnableWizard(project);
        			}else{
        				wizard = new WsdlFirstEnableWizard(project);
        			}
        			
    				RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
    				if(!runtimeMgr.getUseDefaultRuntime() || dialog.getIsJavaFirst()){
            			WizardDialog wizardDialog = new WizardDialog(shell, wizard);
            			wizardDialog.open();
    				}else{
    					wizard.performFinish();
    				}
        		}
        		
        		// change default output location to classes folder
        		IJavaProject javaProject = JavaCore.create(project);
        		javaProject.setOutputLocation(JaxWsWorkspaceManager.getClassesFolder(project).
                    getFullPath(), null);
        		project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);
        	}else{
        		LOG.error("only java project can be jax-ws enabled");
        	}
    	}catch(Exception ex){
    		 LOG.error("error while enabling JAX-WS", ex);
    	}
    }

    public void selectionChanged(IAction action, ISelection sel) {
    }
}
