/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards;


import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaGenerator;
import org.eclipse.stp.sc.jaxws.wizards.wsdltojava.WsdlToJavaGenerateAction;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.stp.sc.jaxws.workspace.ScWsdlFirstNature;
import org.eclipse.stp.sc.jaxws.wsdl.WsdlUtils;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;


public class WsdlFirstProjectWizard extends ProjectWizardBase implements INewWizard, IExecutableExtension {
	
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlFirstProjectWizard.class);
    private static final String VALIDATOR_BUILDER_ID = "org.eclipse.stp.sc.annvalidator";
    
	public static final String WSDL_PAGE = "wsdlPage";
    public static final String GENATOR_PAGE = "genPage";
    
    
    private static Vector<String> linkFiles = new Vector<String>();
    
	WsdlSettingPage wsdlPage;
    WsdlGenPage wsdlGenPage;
    public WsdlFirstProjectWizard() {
        super();
        projectMode = ScJaxWsPropertyConstants.PROJECT_MODE_WSDLFIRST;
    }
    
    public void addPages() {
	    super.addPages();
	    /*
	    ImageDescriptor banner = ScJaxWsResources.getImageDescriptor(WIZARD_IMAGE);
	    
	    runtimePage = new RuntimeSelectionPage(RUNTIME_PAGE, 
	    		ScJaxWsResources.getString("runtimepage.title"), banner);
	    addPage(runtimePage);
	    */
	    wsdlPage = new WsdlSettingPage(WSDL_PAGE);
        addPage(wsdlPage);
        wsdlGenPage = new WsdlGenPage(GENATOR_PAGE);
        addPage(wsdlGenPage);
	}
    
    public boolean performFinish() {
        try {
            super.performFinish();
           
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
	    	IRunnableWithProgress rwp = new IRunnableWithProgress() {
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                	generateFiles(monitor);
                }
	    	};
	        pmd.run(false, false, rwp);            
            
	        ScWsdlFirstNature.addToProject(project);
           
            if(isJaxwsProject()){
	        	BasicNewProjectResourceWizard.updatePerspective(fConfigElement);
	        }
        } catch (Exception e) {
            LOG.error("Error during add builder", e);
        } 
        return true;
    }
    
    private void generateFiles(IProgressMonitor newMonitor){
    	
    	IProgressMonitor checkedMonitor = (newMonitor != null) ? newMonitor
                : new NullProgressMonitor();
    	
    	try{
    	
    	checkedMonitor.beginTask("Generating Java code", 100);
    	
    	IProgressMonitor genWSDLMonitor = new SubProgressMonitor(checkedMonitor, 40);
    	genWSDLMonitor.beginTask("Generating Java code", 10);
    	//generate wsdl files      
    	if (generateWSDLFiles()) {
    		genWSDLMonitor.worked(10);
            //generate code
        	IProgressMonitor genCodeMonitor = new SubProgressMonitor(checkedMonitor, 40);
        	genCodeMonitor.beginTask("Generating Java code", 10);
            generateCode();
            genCodeMonitor.worked(10);	
    	}
    	
        
    	JaxWsWorkspaceManager.setupProjectNature(
    			project, ScJaxWsPropertyConstants.PROJECT_MODE_WSDLFIRST);
        WorkspaceManager.addBuilder(project, VALIDATOR_BUILDER_ID, 
            WorkspaceManager.BuilderOrder.FIRST);
        checkedMonitor.worked(20);
    	} catch (Exception e) {
            LOG.error("Error during add builder", e);
        }
    	finally{    		
    		checkedMonitor.done();
    	}
    }
    
     
    private void generateCode() {
        if (!wsdlPage.IsGenCode()) {
            return;
        }
        LOG.debug("try to generate code");
        WsdlToJavaGenerateAction action = new WsdlToJavaGenerateAction();
        action.setNeedMerge(false);
        Hashtable<String, Object> genParams = new Hashtable<String, Object>();
        
        genParams.put(IWsdlToJavaGenerator.TOOL_SPECIFIC_OPS, wsdlGenPage.paramPage.getParameters());
        String srcDir = JaxWsWorkspaceManager.getSrcFolder(project).getLocation().toOSString();
        LOG.debug("generate code to src dir:" + srcDir);
        genParams.put(IWsdlToJavaGenerator.GEN_OUTPUTDIR, srcDir);
        
        try {
            String wsdlUrl;
            if (wsdlPage.composite.rbtLocalFile.getSelection()) {
                wsdlUrl = wsdlPage.composite.txtFilePath.getText();
            } else {
                wsdlUrl = wsdlPage.composite.txtUrl.getText();
            }
            action.generate(wsdlUrl,
                    project, genParams);
            project.refreshLocal(IProject.DEPTH_INFINITE, null);
        } catch (CoreException e) {
            LOG.error("error during generate code.", e);
        }
    }
    
    
    private boolean generateWSDLFiles(){
    	linkFiles =  new Vector<String>();
    	createWSDLFolder();
    	if (wsdlPage.composite.rbtLocalFile.getSelection()) {
    		String wsdlFilePath = wsdlPage.composite.txtFilePath.getText();
    		if (wsdlFilePath == null || wsdlFilePath.equals("")) {
    			//called from test
    			return false;
    		}
    		createLinkWSDLRecursive(wsdlFilePath);
        } else {
        	importRemoteFile(wsdlPage.composite.txtUrl.getText());
        }  
    	refreshWSDLFolder();
    	return true;
    }
    
    @SuppressWarnings("unchecked")
    private void createLinkWSDLRecursive(String filePath)
    {
        try{
        	if(linkFiles.contains(filePath)){
        		return;
        	}
        	String fileName = new Path(filePath).toFile().getName();
        	createLinkFile(new Path(getWSDLFolder()).append(fileName).toOSString(), filePath);
        	linkFiles.add(filePath);
        	
        	Definition wsdlDef = WsdlUtils.readWSDL(filePath);
        	
        	//process wsdl imports
        	Map wsdlImports = wsdlDef.getImports();
        	if(wsdlImports != null && wsdlImports.size() > 0){
        		Iterator importKeys = wsdlImports.keySet().iterator();
        		while(importKeys.hasNext()){
        			Object key = importKeys.next();
        			Vector<Import> value = (Vector<Import>)wsdlImports.get(key);
        			if(value != null && value.size() > 0){
        				for(int i = 0; i < value.size(); i++){
        					Import im = value.get(i);
        					String uri = im.getLocationURI();
        					String newWSDLFile = getAbsolutePath(filePath, uri);
        					if(newWSDLFile != null){
        						createLinkWSDLRecursive(newWSDLFile);
        					}
        				}
        			}
        		}
        	}
        	
        	//process schema imports
        	if(wsdlDef.getTypes() == null || 
        			wsdlDef.getTypes().getExtensibilityElements() == null){
        		return;
        	}
        	Iterator<ExtensibilityElement> itor = wsdlDef.getTypes().getExtensibilityElements().iterator();
            while (itor.hasNext()) {
                ExtensibilityElement elem = itor.next();
                if (elem instanceof Schema) {
                	createLinkXSDRecursive((Schema)elem);
                }
            }
        }catch (WSDLException ex){
    		LOG.error("error while creating linked file to wsdl", ex);
        }catch (Exception ex) {
        	LOG.error("error while creating linked file to wsdl", ex);
        }
    }
    
    @SuppressWarnings("unchecked")
    private void createLinkXSDRecursive(Schema schema){
    	try{
        	String sourceName = schema.getDocumentBaseURI();
        	if (sourceName.startsWith("http")) {
        		return;
        	}
        	String encodedUrl = sourceName.replaceAll(" ", "%20");
        	URI uri = new URI(encodedUrl);
        	String fileName = new File(uri).getName();
        	String targetName = new Path(getWSDLFolder()).append(fileName).toOSString();
        	createLinkFile(targetName, new File(uri).getPath());
        	
        	Map imports = schema.getImports();
        	if(imports != null && imports.size() > 0){
            	Iterator keys = imports.keySet().iterator();
            	while(keys.hasNext()){
            		Vector<SchemaImport> objs = (Vector<SchemaImport>)imports.get(keys.next());
            		if(objs != null && objs.size() > 0){
            			for(int j = 0; j < objs.size(); j++){
            	 			Schema refSchema = objs.get(j).getReferencedSchema();
            	 			createLinkXSDRecursive(refSchema);
            			}
            		}
            	}                		
        	}
        	
        	List<SchemaReference> includes = (List<SchemaReference>)schema.getIncludes();
        	if(includes != null && includes.size() > 0){
            	for(int i = 0; i < includes.size(); i ++){
            		Schema refSchema = includes.get(i).getReferencedSchema();
            		createLinkXSDRecursive(refSchema);
            	}               		
        	}   		
    	}catch(Exception ex){
    		LOG.error("error while creating linked file to schema " + schema, ex);
    	}

    }
    
    private String getWSDLFolder(){
    	return JaxWsWorkspaceManager.getWSDLFolder(project).getProjectRelativePath().toOSString();
    }
    
    private String getAbsolutePath(String filePath, String uri){
		String returnValue = null;
    	try{
    		if(!uri.startsWith("http:")){
    			IPath newPath = new Path(uri);
    			if(newPath.isAbsolute()){
    				if(uri.startsWith("file:")){
    					java.io.File newFile = new File(new URL(uri).toURI());
    					returnValue = newFile.toString();
    				}else{
    					returnValue = newPath.toOSString();
    				}
    			}else{
    				IPath currentPath = new Path(filePath).removeLastSegments(1);
    				returnValue = currentPath.append(uri).toOSString();
    			}
    		}
    	}catch(Exception ex){
    		LOG.error("error while processing the uri " + uri + " in the file " + filePath, ex);
    		returnValue = null;
    	}
    	
    	return returnValue;
    	
    }
    
    private void createLinkFile(String targetName, String sourceName)
    {
    	if(targetName == null || sourceName == null) 
    		return;
    	try{
        	IFile linkFile = project.getFile(new Path(targetName));
    		if(linkFile.exists()){
        		LOG.info("the link file is already existed: " +  
        				targetName);
        		return;
        	}
        	IStatus status = project.getWorkspace().validateLinkLocation(linkFile,new Path(sourceName));
        	if (status.getSeverity() == IStatus.ERROR || status.getSeverity() ==
        		IStatus.CANCEL) { 
        		  LOG.error("error while creating linked file: " +  
        				  sourceName);
        		  } else {
        			  linkFile.createLink(new Path(sourceName), IResource.NONE, null);
        		     LOG.info(status.getMessage());
        		 }
    	} catch (CoreException e)
    	{
    		LOG.error("error while creating linked file to wsdl", e);
    	}
    }
    
    private void importRemoteFile(String urlStr)
    {
    	InputStream is = null;
    	FileOutputStream fos = null;
    	IContainer linkFolder = JaxWsWorkspaceManager.getWSDLFolder(project);
    	try {
        	URL url = new URL(urlStr);
			String fileName = url.getFile();
			if(!fileName.toLowerCase().endsWith(".wsdl"))
				fileName = new String(fileName + ".wsdl");
			IPath filePath = linkFolder.getLocation().append(fileName);
			File file = filePath.toFile();
			if(file.exists())
				file.delete();
			file.createNewFile();
			fos=new FileOutputStream(file);
			URLConnection yc = url.openConnection();
			is = yc.getInputStream();
			byte[] b=new byte[1024 * 5];
			int len = 0;
			while ((len=is.read(b))!=-1) {
				fos.write(b, 0, len);
			}
		} catch (Exception e) {
			LOG.error("error while reading from the url: " + urlStr, e);
		} finally{
			try{
				if(is != null)
					is.close();
				if(fos != null)
					fos.close();
			}catch (Exception e){
				LOG.error("error while closing input/output stream", e);
			}
		}
    }
    
    private void createWSDLFolder(){
    	try{
    		IContainer linkFolder = JaxWsWorkspaceManager.getWSDLFolder(project);
        	if(!linkFolder.exists() && linkFolder instanceof IFolder){
        		((IFolder)linkFolder).create(true, true, null);
        	}   		
    	}catch (Exception e){
    		LOG.error("error while creating wsdl folder", e);
    	}
    }
    
    private void refreshWSDLFolder(){
    	try{
    		IContainer linkFolder = JaxWsWorkspaceManager.getWSDLFolder(project);
        	if(linkFolder.exists()){
        		linkFolder.refreshLocal(IResource.DEPTH_INFINITE, null);
        	}   		
    	}catch (CoreException e){
    		LOG.error("error while refreshing wsdl folder", e);
    	}    	
    }
    
    /**
     * get the wsdl url from wsdl selection page
     * @return
     */
    public String getWsdlURL() {
    	if (wsdlPage.composite.rbtLocalFile.getSelection()) {
            return wsdlPage.composite.txtFilePath.getText();
        } else {
            return wsdlPage.composite.txtUrl.getText();
        }
    }
    
    
    public boolean canFinish() {
		IWizardPage[] pages = getPages();
		if (!wsdlPage.IsGenCode()) {
			for (int i = 0; i < pages.length; i++) {
				if (!pages[i].isPageComplete()
						&& !(pages[i] instanceof WsdlGenPage)) {
					return false;
				}
			}

			return true;
		}

		return super.canFinish();
	}
    
    
     
}
