/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.AbstractList;

import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NewHandlerWizardPage extends NewTypeWizardPage{
	
	private final static String HANDLER_CHAIN_FILE_EXTENSION = "xml"; 
	private final static String JAVA_FILE_EXTENSION = "java"; 
	private final static String PACKAGE_KEY_WORLD = "package"; 
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlFirstProjectWizard.class);

	//handler class template definitions
	private static final String LOGICAL_HANDLER_CLASS_TEMPLATE = "etc/templates/LogicalHandler.java_template";
	private static final String SOAP_HANDLER_CLASS_TEMPLATE = "etc/templates/SOAPHandler.java_template";
	private static final String PACKAGE_NAME_REPLACED = "$packageName";
	private static final String CLASS_NAME_REPLACED = "$className";
	private static final String USE_DEFAULT_PACKAGE = "//package default";
	
	//default values when create a new handler
	private static final boolean IS_ASSOCIATED_WITH_SERVICE_DEFAULT = true;
	private static final boolean IS_ADDED_TO_CHAIN_DEFAULT = false;
	private static final boolean IS_CREATE_NEW_CHAIN_FILE_DEFAULT = true;
	private static final boolean IS_LOGICAL_HANDLER_TYPE_DEFAULT = true;
	
	private static final String LINE_SEPARATOR = System.getProperty("line.separator");
	
	//UI components
	private Button btnLogicalType = null;
	private Button btnProtocalType = null;
	private Button btnIsAddedToChain = null;
	private Button btnIsAssociated = null;
	private Button btnIsCreateNewChainFile = null;
	private Button btnIsUseExistingChainFile = null;
	private Text txtExistingChainFilePath = null;
	private Text txtNewChainFilePath = null;
	private Text txtServiceClass = null;
	private Group grpHandlerClass = null;
	private Group grpHandlerChain = null;
	private Group grpHandlerType = null;
	private Composite cmpHandlerBinding = null;
	private Composite cmpExistingChain = null;
	private Composite cmpNewChain = null;
	
	//validation and error messages
	private String errMessageHandlerChain = null;
	private String errMessageWebService = null;
	private static final String ERROR_MESSAGE_NOT_HAVE_WEBSERVICE_ANN = "The primary class of this java file doesn't have @WebService annotation.";
	private static final String ERROR_MESSAGE_NOT_A_JAVA_FILE = "This file should be a java file.";
	private static final String ERROR_MESSAGE_FILE_NOT_EXIST = "This file doesn't exist.";
	private static final String ERROR_MESSAGE_FILE_ALREADY_EXIST = "This file already exists.";
	private static final String ERROR_MESSAGE_NOT_A_XML_FILE = "This file is not an XML file.";
	private static final String ERROR_MESSAGE_INVALID_HANDLER_CHAIN_FILE = "This file is not an valid handler chain file.";
	private static final String ERROR_MESSAGE_INVALID_HANDLER_CHAIN_PREFIX = "Invalid handler chain file path. ";
	private static final String ERROR_MESSAGE_INVALID_SERVICE_CLASS_PREFIX = "Invalid service class file path. ";
	private boolean isHandlerChainFilePathValid = false;
	private boolean isServiceClassFilePathValid = false;
	private boolean isNewClassGroupValid = false;
	
	private IStructuredSelection curSelection = null;

	public NewHandlerWizardPage(){
		super(false, ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.Title"));
		setTitle(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.Title"));
		setDescription(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.Description"));			 

	}
	
	public void init(IStructuredSelection selection) {
		IJavaElement jelem= getInitialJavaElement(selection);
		initContainerPage(jelem);
		initTypePage(jelem);
		doStatusUpdate();
		curSelection = selection;
	}		
	
	// ------ validation --------
	private void doStatusUpdate() {
		// all used component status
		IStatus[] status= new IStatus[] {
			fContainerStatus,
			fPackageStatus,
			fTypeNameStatus
		};
		
		// the mode severe status will be displayed and the OK button enabled/disabled.
		updateStatus(status);
	}

			
	/*
	 * @see NewContainerWizardPage#handleFieldChanged
	 */
	protected void handleFieldChanged(String fieldName) {
		super.handleFieldChanged(fieldName);
		
		doStatusUpdate();
	}
	
	/*
	 * @see WizardPage#becomesVisible
	 */
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		if (visible) {
			setFocus();
		}
	}
	
	protected void updateStatus(IStatus[] status){
		super.updateStatus(status);
		if(isPageComplete()){
			isNewClassGroupValid = true;
			validateHandlerCfgGroup();
		}else{
			isNewClassGroupValid = false;
		}
	}
	
	/**
	 * UI
	 */
	public void createControl(Composite parent){
        Composite container = new Composite(parent, SWT.FILL);
		GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        container.setLayout(gridLayout);
		GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 1;
	    container.setLayoutData(gridData);
	    
        createNewHandlerClassGroup(container);
	    
	    createHandlerTypeGroup(container);
        
        createHandlerConfigurationGroup(container);
        
        initControls(curSelection);
        
        setControl(container);		
	}

	private void createNewHandlerClassGroup(Composite parent){
		grpHandlerClass = new Group(parent, SWT.NONE);
		grpHandlerClass.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerClassGroup.Label"));
		GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        grpHandlerClass.setLayout(gridLayout);
		GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 1;
	    gridData.grabExcessHorizontalSpace = true;
	    grpHandlerClass.setLayoutData(gridData);
	    
		createContainerControls(grpHandlerClass, 4);	
		createPackageControls(grpHandlerClass, 4);
		createTypeNameControls(grpHandlerClass, 4);
	}
	
	private void createHandlerTypeGroup(Composite parent){
		grpHandlerType = new Group(parent, SWT.NONE);
		grpHandlerType.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerTypeGroup.Label"));
		GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        grpHandlerType.setLayout(gridLayout);
		GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 1;
	    gridData.grabExcessHorizontalSpace = true;
	    grpHandlerType.setLayoutData(gridData);


		btnLogicalType = new Button(grpHandlerType, SWT.RADIO);
		btnLogicalType.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerTypeGroup.LogicalButton.Label"));
	
		btnProtocalType = new Button(grpHandlerType, SWT.RADIO);
		btnProtocalType.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerTypeGroup.ProtocolButton.Label"));
	}
	
	private void createHandlerConfigurationGroup(Composite parent){
		Group grpHandlerConfiguration = new Group(parent, SWT.NONE);
		grpHandlerConfiguration.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.Label"));
		GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        grpHandlerConfiguration.setLayout(gridLayout);
		GridData gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 1;
	    gridData.grabExcessHorizontalSpace = true;
	    grpHandlerConfiguration.setLayoutData(gridData);
	    
	    btnIsAddedToChain = new Button(grpHandlerConfiguration, SWT.CHECK);
	    btnIsAddedToChain.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.CheckButton.label"));
	    btnIsAddedToChain.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				if(grpHandlerChain != null) {
					enableConfiguration(btnIsAddedToChain.getSelection());
					validateHandlerCfgGroup();
				}
			}
		});	
	    
	    grpHandlerChain = new Group(grpHandlerConfiguration, SWT.NONE);
		gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        grpHandlerChain.setLayout(gridLayout);
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 1;
	    gridData.grabExcessHorizontalSpace = true;
	    grpHandlerChain.setLayoutData(gridData);
	    
		btnIsCreateNewChainFile = new Button(grpHandlerChain, SWT.RADIO);
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 3;
	    btnIsCreateNewChainFile.setLayoutData(gridData);
	    btnIsCreateNewChainFile.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.NewChainButton.label"));
	    btnIsCreateNewChainFile.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				if(cmpNewChain != null) {
					setCompositeEnable(cmpNewChain, btnIsCreateNewChainFile.getSelection());
				}
				updateHandlerChainFilePathValidStatus();
			}
		});	
	    
	    cmpNewChain = new Composite(grpHandlerChain, SWT.NONE);
		gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        cmpNewChain.setLayout(gridLayout);
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 3;
	    gridData.grabExcessHorizontalSpace = true;
	    cmpNewChain.setLayoutData(gridData);
	    
	    new Label(cmpNewChain, SWT.NULL).setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.FilePathLabel"));
		txtNewChainFilePath = new Text(cmpNewChain, SWT.SINGLE | SWT.BORDER);
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		txtNewChainFilePath.setLayoutData(gridData);
		txtNewChainFilePath.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent event){
				updateHandlerChainFilePathValidStatus();
			}
		});
		Button btnBrowseFile = new Button(cmpNewChain ,SWT.PUSH);
		btnBrowseFile.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.CreateButton.label"));
		btnBrowseFile.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				CreateXmlFileWizard wizard = new CreateXmlFileWizard();
		        wizard.init(PlatformUI.getWorkbench(), NewHandlerWizardPage.this.curSelection);
		        wizard.setNeedsProgressMonitor(true);
		        WizardDialog dialog = new WizardDialog(NewHandlerWizardPage.this.getShell(), wizard);
		        dialog.create();
		        int rtnCode  = dialog.open();
		        if(rtnCode == WizardDialog.OK){
		        	IFile tmpFile = NewHandlerWizardPage.this.getFileFromPath(wizard.getFilePath().toString());
		        	if(tmpFile != null){
		        		txtNewChainFilePath.setText(tmpFile.getLocation().toOSString());	
		        	}
		        }
		        
			}
		});	    
	    
		btnIsUseExistingChainFile = new Button(grpHandlerChain, SWT.RADIO);
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 3;
	    btnIsUseExistingChainFile.setLayoutData(gridData);
	    btnIsUseExistingChainFile.setText(ScJaxWsResources.getString("Add this handler to an existing handler chain file"));
	    btnIsUseExistingChainFile.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				if(cmpExistingChain != null) {
					setCompositeEnable(cmpExistingChain, btnIsUseExistingChainFile.getSelection());
				}
				updateHandlerChainFilePathValidStatus();
			}
		});
	    
	    cmpExistingChain = new Composite(grpHandlerChain, SWT.NONE);
		gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        cmpExistingChain.setLayout(gridLayout);
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 3;
	    gridData.grabExcessHorizontalSpace = true;
	    cmpExistingChain.setLayoutData(gridData);	    
	    
	    new Label(cmpExistingChain, SWT.NULL).setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.FilePathLabel"));
		txtExistingChainFilePath = new Text(cmpExistingChain, SWT.SINGLE | SWT.BORDER);
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		txtExistingChainFilePath.setLayoutData(gridData);
		txtExistingChainFilePath.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent event){
				updateHandlerChainFilePathValidStatus();
			}
		});
		Button btnBrowseFile2 = new Button(cmpExistingChain ,SWT.PUSH);
		btnBrowseFile2.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.BrowseButton.label"));
		btnBrowseFile2.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				ElementTreeSelectionDialog dialog = 
					new ElementTreeSelectionDialog(
						NewHandlerWizardPage.this.getShell(), 
						new WorkbenchLabelProvider(),
						new WorkbenchContentProvider()); 
				dialog.setInput(ResourcesPlugin.getWorkspace().getRoot());
				dialog.setAllowMultiple(false);
				ViewerFilter filter = new ViewerFilter() {
					public boolean select(Viewer viewer, Object parent, Object element) {
						if (element instanceof IFile) {
							if(!((IFile)element).getFileExtension().equalsIgnoreCase(HANDLER_CHAIN_FILE_EXTENSION)){
								return false;
							}
						}
						return true;
					}
				};	
				dialog.addFilter(filter);
				ISelectionStatusValidator validator = new ISelectionStatusValidator(){
					public IStatus validate(Object[] selection) {
						if(selection != null &&
								selection.length > 0 &&
								selection[0] instanceof IFile){
							if(((IFile)selection[0]).getFileExtension().equalsIgnoreCase(HANDLER_CHAIN_FILE_EXTENSION)){
								if(isValidHandlerChainFile(((IFile)selection[0]).getLocation().toFile())){
									return Status.OK_STATUS;
								}else{
									return new Status(Status.ERROR, ScJaxWsPlugin.PLUGIN_ID, Status.ERROR,
											"This file is not a valid handler chain file.", null);
								}
							}								
						}
						return new Status(Status.ERROR, ScJaxWsPlugin.PLUGIN_ID, Status.ERROR,
								"Please chose a xml file.", null);
					}
				};
				dialog.setValidator(validator);
				if(ElementTreeSelectionDialog.OK == dialog.open()){
					Object result = dialog.getFirstResult();
					if(result instanceof IFile){
						txtExistingChainFilePath.setText(((IFile)result).getLocation().toOSString());
					}
				}
				
			}
		});
		
		//separator line
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 3;
		new Label(grpHandlerChain, SWT.SEPARATOR | SWT.HORIZONTAL).setLayoutData(gridData);

		btnIsAssociated = new Button(grpHandlerChain, SWT.CHECK);
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 3;
	    btnIsAssociated.setLayoutData(gridData);
		btnIsAssociated.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.BindingServiceButton.label"));
		btnIsAssociated.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				if(cmpHandlerBinding != null) {
					setCompositeEnable(cmpHandlerBinding, btnIsAssociated.getSelection());
				}
				updateServiceClassFilePathValidStatus();
			}
		});	
		
		cmpHandlerBinding = new Composite(grpHandlerChain, SWT.CHECK);
		gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        cmpHandlerBinding.setLayout(gridLayout);
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
	    gridData.horizontalSpan = 3;
	    gridData.grabExcessHorizontalSpace = true;
	    cmpHandlerBinding.setLayoutData(gridData);

	    new Label(cmpHandlerBinding, SWT.NULL).setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.ServiceClassLabel"));
	    txtServiceClass = new Text(cmpHandlerBinding, SWT.SINGLE | SWT.BORDER);
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		txtServiceClass.setLayoutData(gridData);
		txtServiceClass.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent event){
				updateServiceClassFilePathValidStatus();
			}
		});		
		Button btnBrowseServiceClass = new Button(cmpHandlerBinding ,SWT.PUSH);
		btnBrowseServiceClass.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.BrowseButton.label"));
		btnBrowseServiceClass.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				ElementTreeSelectionDialog dialog = 
					new ElementTreeSelectionDialog(
						NewHandlerWizardPage.this.getShell(), 
						new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), 
						new StandardJavaElementContentProvider()); 
				dialog.setInput(JavaCore.create(ResourcesPlugin.getWorkspace().getRoot()));
				dialog.setAllowMultiple(false);
				Class[] acceptedClasses = null;
				acceptedClasses = new Class[] { IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class, IPackageFragment.class, IPackageFragment.class, ICompilationUnit.class };
				ViewerFilter filter = new MyTypedViewerFilter(acceptedClasses) {
					public boolean select(Viewer viewer, Object parent, Object element) {
						if (element instanceof IPackageFragmentRoot) {
							try {
								return (((IPackageFragmentRoot)element).getKind() == IPackageFragmentRoot.K_SOURCE);
							} catch (JavaModelException e) {
								LOG.error(e); // just log, no ui in validation
								return false;
							}
						}
						return super.select(viewer, parent, element);
					}
				};	
				dialog.addFilter(filter);
				ISelectionStatusValidator validator = new ISelectionStatusValidator(){
					public IStatus validate(Object[] selection) {
						if(selection != null &&
								selection.length > 0 &&
								selection[0] instanceof ICompilationUnit){
							if(hasWebServiceAnn((ICompilationUnit)selection[0])){
									return Status.OK_STATUS;
							}								
						}
						return new Status(Status.ERROR, ScJaxWsPlugin.PLUGIN_ID, Status.ERROR,
								"Please chose a web service java file.", null);
					}
				};
				dialog.setValidator(validator);
				if(ElementTreeSelectionDialog.OK == dialog.open()){
					ICompilationUnit result = (ICompilationUnit)dialog.getFirstResult();
					IFile tmpFile = NewHandlerWizardPage.this.getFileFromPath(result.getPath().toString());
					if(tmpFile != null){
						txtServiceClass.setText(tmpFile.getLocation().toOSString());
					}
				}
			}
		});
	}
	
	//set value for controls
	private void initControls(boolean isAddedToChain, boolean isNewChainFile, boolean isServiceBinding){
		btnLogicalType.setSelection(IS_LOGICAL_HANDLER_TYPE_DEFAULT);
		btnProtocalType.setSelection(!IS_LOGICAL_HANDLER_TYPE_DEFAULT);
		btnIsAddedToChain.setSelection(isAddedToChain);
		btnIsAssociated.setSelection(isServiceBinding);
		btnIsCreateNewChainFile.setSelection(isNewChainFile);
		btnIsUseExistingChainFile.setSelection(!isNewChainFile);
		enableConfiguration(isAddedToChain);
	}
	
	//set default value with the selection
	private void initControls(IStructuredSelection selection){
		if(selection != null){
			Object obj  = selection.getFirstElement();
			IFile webServiceFile = null;
			IFile handlerChainFile = null;
			if(obj instanceof IFile){
				if(((IFile)obj).getFileExtension().equalsIgnoreCase(JAVA_FILE_EXTENSION)
						&& hasWebServiceAnn((IFile)obj)){
						webServiceFile = (IFile)obj;
						handlerChainFile = getHandlerChainFilePathFromWebServiceFileAnn(webServiceFile);
				}else if (((IFile)obj).getFileExtension().equalsIgnoreCase(HANDLER_CHAIN_FILE_EXTENSION)
						&& isValidHandlerChainFile(((IFile)obj).getLocation().toFile())){
							handlerChainFile = (IFile)obj;
				}

			}else if(obj instanceof ICompilationUnit
					&& hasWebServiceAnn((ICompilationUnit)obj)){
				webServiceFile = (IFile)((ICompilationUnit)obj).getResource();
				handlerChainFile = getHandlerChainFilePathFromWebServiceFileAnn(webServiceFile);
			}
			
			if(webServiceFile != null){
				txtServiceClass.setText(webServiceFile.getLocation().toOSString());
				if(handlerChainFile == null){
					initControls(true, IS_CREATE_NEW_CHAIN_FILE_DEFAULT, true);
				}else{
					initControls(true, false, true);
					if(handlerChainFile.exists()){
						txtExistingChainFilePath.setText(handlerChainFile.getLocation().toOSString());
					}
				}
			}else if(handlerChainFile != null){
				initControls(true, false, IS_ASSOCIATED_WITH_SERVICE_DEFAULT);
				if(handlerChainFile.exists()){
					txtExistingChainFilePath.setText(handlerChainFile.getLocation().toOSString());
				}
			}else{
				initControls(IS_ADDED_TO_CHAIN_DEFAULT, IS_CREATE_NEW_CHAIN_FILE_DEFAULT, IS_ASSOCIATED_WITH_SERVICE_DEFAULT);
			}
		}else{
			initControls(IS_ADDED_TO_CHAIN_DEFAULT, IS_CREATE_NEW_CHAIN_FILE_DEFAULT, IS_ASSOCIATED_WITH_SERVICE_DEFAULT);
		}
		
		//set valid status
		upateHandlerCfgGroupStatus();
	}
	
	private IFile getHandlerChainFilePathFromWebServiceFileAnn(IFile file){
		IFile rtnValue = null;
		if(file != null){
			Annotation handlerChainNode = getHandlerChainAnn(file);
			
			if(handlerChainNode != null && handlerChainNode.isNormalAnnotation()){
				AbstractList<MemberValuePair> list = 
					(AbstractList<MemberValuePair>)((NormalAnnotation)handlerChainNode).values();
				if(list != null && list.size() > 0){
					for(int i = 0; i < list.size(); i++){
						MemberValuePair valuePair = list.get(i);
						if(valuePair.getName().getIdentifier().equalsIgnoreCase("file")){
							String handlerChainFilePath = valuePair.getValue().toString();
							if(handlerChainFilePath != null && handlerChainFilePath.length() > 0){
								handlerChainFilePath = handlerChainFilePath.replaceAll("\"", "");
								IPath path = null;
								try{
									//this path is an absolute URL
									URL url = new URL(handlerChainFilePath);
									if(url.getProtocol().equalsIgnoreCase("file")){
										path = new Path(url.getFile());
									}else{
										break;
									}
								}catch (Exception e){
									//this path is not a absolute URL
									path = new Path(handlerChainFilePath);
								}
								if(path.isAbsolute()){
									rtnValue = getFileFromPath(path.toString());
								}else{
									rtnValue = getFileFromPath(file.getFullPath().append(path).toString());
								}
								break;
							}
						}
					}
				}
			}
		}
		return rtnValue;
	}
	
	private void setCompositeEnable(Composite composite, boolean isEnable){
		if(composite != null) {
			Control[] children = composite.getChildren();
			if(children != null && children.length >  0){
				for(int i = 0; i < children.length; i++){
					if(children[i] instanceof Composite)
					{
						setCompositeEnable((Composite)children[i], isEnable);
					}
					children[i].setEnabled(isEnable);
				}
			}
			composite.setEnabled(isEnable);
		}
	}
	
	private void enableConfiguration(boolean isEnable){
		if(grpHandlerChain != null){
			if(isEnable){
				setCompositeEnable(grpHandlerChain, true);
				
				if(btnIsCreateNewChainFile != null){
					setCompositeEnable(cmpNewChain, btnIsCreateNewChainFile.getSelection());
				}
				if(btnIsUseExistingChainFile != null){
					setCompositeEnable(cmpExistingChain, btnIsUseExistingChainFile.getSelection());
				}
				if(btnIsAssociated != null){
					setCompositeEnable(cmpHandlerBinding, btnIsAssociated.getSelection());
				}
			}else{
				setCompositeEnable(grpHandlerChain, false);
			}
		}
	}
	
	private String getHandlerClassContents(boolean isLogicalType){
		String rtnValue = "";
		InputStream fis = null;
		try{
			IPath path = null;
			if(isLogicalType){
				path = new Path(LOGICAL_HANDLER_CLASS_TEMPLATE);
			}else
			{
				path =new Path(SOAP_HANDLER_CLASS_TEMPLATE);
			}
			fis = FileLocator.openStream(ScJaxWsPlugin.getDefault().getBundle(), path, false);
	        StringBuffer sb=new StringBuffer();
	        BufferedReader in = new BufferedReader(new InputStreamReader(fis));

	        String line = null;
	        while((line = in.readLine())!= null){
	        	sb.append(line + LINE_SEPARATOR);
	        }
	        
	        //replace class name
	        int start = sb.indexOf(CLASS_NAME_REPLACED);
        	int end = start + CLASS_NAME_REPLACED.length();
        	if(start >= 0){
            	sb.replace(start, end, getTypeName().trim());
        	}
	        
	        //replace package name
	        String packageName = getPackageText();
	        if(packageName == null || packageName.trim().length() == 0){
	        	//remove package declaration part
	        	start = sb.indexOf(PACKAGE_KEY_WORLD + " " + PACKAGE_NAME_REPLACED + ";");
	        	end = (PACKAGE_KEY_WORLD + " " + PACKAGE_NAME_REPLACED + ";").length();
	        	if(start >= 0){
	        		sb.replace(start, end, USE_DEFAULT_PACKAGE);
	        	}
	        }else{
		        //replace the package variable in the template with the package value
	        	start = sb.indexOf(PACKAGE_NAME_REPLACED);
	        	end = start + PACKAGE_NAME_REPLACED.length();
	        	if(start >= 0)
	        	{
	        		sb.replace(start, end, packageName.trim());
	        	}
	        }

	        rtnValue = sb.toString();
		}catch(IOException e){
			LOG.error(e.getMessage(), e);
		}finally{
			if (fis != null){
				try{
					fis.close();
				}catch(Exception e){
					LOG.error(e.getMessage(), e);
				}
			}
		}

		return rtnValue;
	}
	
	private boolean isValidHandlerChainFile(File file){
		boolean rtnValue = false;
		try{
			DocumentBuilder db = null;
			Document doc = null;
			if(file != null)
				db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
				if(file.exists()){
					doc = db.parse(file);
					Element rootElement = doc.getDocumentElement();
					String nodeName = rootElement.getNodeName();
					if(nodeName.endsWith("handler-chains")){
						rtnValue = true;
					}
				}
		}catch(Exception e){
			rtnValue = false;
		}
		return rtnValue;
	}
	
	private void updateHandlerChainFilePathValidStatus(){
		isHandlerChainFilePathValid = false;
		errMessageHandlerChain = null;
		String path = getHandlerChainFilePath();
		IFile file = getFileFromPath(path);
		if(file != null){
			if(file.getFileExtension() != null && 
					file.getFileExtension().equalsIgnoreCase(HANDLER_CHAIN_FILE_EXTENSION)){
				if(!file.getName().equalsIgnoreCase("." + HANDLER_CHAIN_FILE_EXTENSION)){
					if(getIsCreateNewChain()){
						if(file.exists()){
							errMessageHandlerChain = ERROR_MESSAGE_FILE_ALREADY_EXIST;
						}else{
							isHandlerChainFilePathValid = true;
							errMessageHandlerChain = null;
						}
					}else if(getIsUseExistingChain()){
						if(file.exists()){
							if(isValidHandlerChainFile(file.getLocation().toFile())){
								isHandlerChainFilePathValid = true;
								errMessageHandlerChain = null;
							}else{
								errMessageHandlerChain = ERROR_MESSAGE_INVALID_HANDLER_CHAIN_FILE;
							}
						}else{
							errMessageHandlerChain = ERROR_MESSAGE_FILE_NOT_EXIST;
						}
					}
				}
			}else{
				errMessageHandlerChain = ERROR_MESSAGE_NOT_A_XML_FILE;
			}
		}
		if(!isHandlerChainFilePathValid){
			if(errMessageHandlerChain != null){
				errMessageHandlerChain = ERROR_MESSAGE_INVALID_HANDLER_CHAIN_PREFIX + errMessageHandlerChain;
			}else{
				errMessageHandlerChain = ERROR_MESSAGE_INVALID_HANDLER_CHAIN_PREFIX;
			}
			
		}
		
		validateHandlerCfgGroup();
	}
	
	private void updateServiceClassFilePathValidStatus(){
		isServiceClassFilePathValid = false;
		errMessageWebService = null;
		if(getIsAssociated()){
			IFile file = getFileFromPath(getServiceClassFilePath());
			if(file != null){
				if(file.exists()){
					if(file.getFileExtension().equalsIgnoreCase(JAVA_FILE_EXTENSION)){
						if(hasWebServiceAnn(file)){
							isServiceClassFilePathValid = true;
							errMessageWebService = null;
						}else{
							errMessageWebService = ERROR_MESSAGE_NOT_HAVE_WEBSERVICE_ANN;
						}
					}else{
						errMessageWebService = ERROR_MESSAGE_NOT_A_JAVA_FILE;
					}
				}else{
					errMessageWebService = ERROR_MESSAGE_FILE_NOT_EXIST;
				}
			}
		}else{
			isServiceClassFilePathValid = true;
		}
		
		if(!isServiceClassFilePathValid){
			if(errMessageWebService != null){
				errMessageWebService = ERROR_MESSAGE_INVALID_SERVICE_CLASS_PREFIX + errMessageWebService;
			}else{
				errMessageWebService = ERROR_MESSAGE_INVALID_SERVICE_CLASS_PREFIX;
			}
		}
		
		validateHandlerCfgGroup();
	}
	
	private void upateHandlerCfgGroupStatus(){
		updateHandlerChainFilePathValidStatus();
		updateServiceClassFilePathValidStatus();
	}
	
	private void validateHandlerCfgGroup(){
		if(isNewClassGroupValid){
			if(getIsHandlerConfigGroupValid()){
				setPageComplete(true);
				setErrorMessage(null);
			}else{
				setPageComplete(false);
				setErrorMessage(getCfgErrorMessage());
			}
		}
	}
	
	public String getCfgErrorMessage(){
		if(errMessageHandlerChain != null){
			return errMessageHandlerChain;
		}else{
			return errMessageWebService;
		}
	}
	
	public IFile getFileFromPath(String path){
		IFile rtnValue = null;
		try{
			if(path != null && path.length() > 0){
				IWorkspace workspace = ResourcesPlugin.getWorkspace();
				IPath workspacePath = workspace.getRoot().getLocation();
				
				//change local file system path to workspace relative path 
				if (path.startsWith(workspacePath.toOSString())){
					path = path.substring(workspacePath.toOSString().length());
					
				}else if(path.startsWith(workspacePath.toString())){
					path = path.substring(workspacePath.toString().length());
				}
				IPath newPath = new Path(path);
				rtnValue = workspace.getRoot().getFile(newPath);
				if(rtnValue == null){
					rtnValue = workspace.getRoot().getFileForLocation(newPath);
				}
			}
		}catch (Exception e){
			rtnValue = null;
			LOG.debug(e);
		}

		return rtnValue;
	}
	
	private boolean hasWebServiceAnn(IFile file){
		boolean rtnValue = false;

		if(file != null && file.exists() &&
				file.getFileExtension().equalsIgnoreCase(JAVA_FILE_EXTENSION)){
			ICompilationUnit cu = JDTUtils.getJavaUnitFromFile(file);
			if(hasWebServiceAnn(cu)){
				rtnValue = true;
			}
		}

		return rtnValue;
	}
	
	private boolean hasWebServiceAnn(ICompilationUnit cu){
		boolean rtnValue = false;
		if(cu != null){
			IMember targetMember = cu.findPrimaryType();
			if(targetMember != null){
				CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit(targetMember);
				Annotation node = ScAnnotationSupportUtils.getDefaultedAnnotationNode(
						WebService.class,
	                    astRoot,
	                    targetMember,
	                    null);
				if(JDTUtils.hasAnnotation(targetMember, node)){
					rtnValue = true;
				}								
			}
		}
		return rtnValue;
	}
	
	private Annotation getHandlerChainAnn(IFile file){
		Annotation rtnValue = null;
		if(file != null && file.exists() &&
				file.getFileExtension().equalsIgnoreCase(JAVA_FILE_EXTENSION)){
			ICompilationUnit cu = JDTUtils.getJavaUnitFromFile(file);
			if(cu != null){
				IMember targetMember = cu.findPrimaryType();
				if(targetMember != null){
					CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit(targetMember);
					Annotation node = ScAnnotationSupportUtils.getDefaultedAnnotationNode(
							HandlerChain.class,
		                    astRoot,
		                    targetMember,
		                    null);
					rtnValue = JDTUtils.findAnnotation(astRoot, targetMember, node);
				}
			}
		}		
		return rtnValue;
	}

	private boolean getIsHandlerConfigGroupValid(){
		if(getIsAddedToChain()){
			return (isHandlerChainFilePathValid && isServiceClassFilePathValid);
		}else{
			return true;
		}
	}
	

	
	public boolean getIsLogicalHandlerType(){
		return btnLogicalType.getSelection();
	}
	
	public boolean getIsAddedToChain(){
		return btnIsAddedToChain.getSelection();
	}
	
	public boolean getIsAssociated(){
		return btnIsAssociated.getSelection();
	}
	
	public boolean getIsCreateNewChain(){
		return btnIsCreateNewChainFile.getSelection();
	}

	public boolean getIsUseExistingChain(){
		return btnIsUseExistingChainFile.getSelection();
	}

	public String getHandlerChainFilePath(){
		String rtnValue = "";
		if(getIsAddedToChain()){
			if(getIsCreateNewChain()){
				if(txtNewChainFilePath.getText() != null){
					rtnValue = txtNewChainFilePath.getText().trim();
					if(!rtnValue.toLowerCase().endsWith("." + HANDLER_CHAIN_FILE_EXTENSION)){
						rtnValue = rtnValue + "." + HANDLER_CHAIN_FILE_EXTENSION;
					}
				}
			}else if(getIsUseExistingChain()){
				if(txtExistingChainFilePath.getText() != null){
					rtnValue = txtExistingChainFilePath.getText().trim();
				}
			}
		}
		return rtnValue;
	}
	
	public String getServiceClassFilePath(){
		String rtnValue = "";
		if(getIsAddedToChain()){
			if(getIsAssociated()){
				if(txtServiceClass.getText() != null){
					rtnValue = txtServiceClass.getText().trim();
				}
			}
		}
		return rtnValue;
	}
	
	public String getHandlerChainFilePathAbsolute(){
		String rtnValue = getHandlerChainFilePath();
		IFile file = getFileFromPath(rtnValue);
		if(file != null){
			rtnValue = file.getLocation().toString();
		}

		return rtnValue;
	}
	
	public void createHandlerClass(IProgressMonitor monitor){
		if (monitor == null) {
			monitor= new NullProgressMonitor();
		}
		
		try{
			IPackageFragmentRoot root= getPackageFragmentRoot();
			IPackageFragment pack= getPackageFragment();
			if (pack == null) {
				pack= root.getPackageFragment(""); //$NON-NLS-1$
			}
			
			//create package if needed
			if (!pack.exists()) {
				String packName= pack.getElementName();
				pack= root.createPackageFragment(packName, true, new SubProgressMonitor(monitor, 1));
			} else {
				monitor.worked(1);
			}
			
			//create class
			String typeName = getTypeName();
			String cuName= getCompilationUnitName(typeName);
			pack.createCompilationUnit(
					cuName, 
					getHandlerClassContents(getIsLogicalHandlerType()), 
					false, 
					new SubProgressMonitor(monitor, 2)); //$NON-NLS-1$
		}catch(CoreException e){
			LOG.error(e.getMessage(), e);
		}

	}
	
	public void setNewHandlerChainFilePath(String path){
		if (path != null && path.length() > 0 && txtNewChainFilePath != null){
			txtNewChainFilePath.setText(path);
		}
	}
	
	public void setExistingHandlerChainFilePath(String path){
		if (path != null && path.length() > 0 && txtExistingChainFilePath != null){
			txtExistingChainFilePath.setText(path);
		}
	}
	
	public void setWebServiceClassPath(String path){
		if (path != null && path.length() > 0 && txtServiceClass != null ){
			txtServiceClass.setText(path);
		}
	}
	
	
	/**
	 * Viewer filter used in selection dialogs.
	 */
	private class MyTypedViewerFilter extends ViewerFilter {

		private Class[] fAcceptedTypes;
		private Object[] fRejectedElements;

		/**
		 * Creates a filter that only allows elements of gives types.
		 * @param acceptedTypes The types of accepted elements
		 */
		public MyTypedViewerFilter(Class[] acceptedTypes) {
			this(acceptedTypes, null);
		}

		/**
		 * Creates a filter that only allows elements of gives types, but not from a
		 * list of rejected elements.
		 * @param acceptedTypes Accepted elements must be of this types
		 * @param rejectedElements Element equals to the rejected elements are
		 * filtered out
		 */	
		public MyTypedViewerFilter(Class[] acceptedTypes, Object[] rejectedElements) {
			Assert.isNotNull(acceptedTypes);
			fAcceptedTypes= acceptedTypes;
			fRejectedElements= rejectedElements;
		}	

		/**
		 * @see ViewerFilter#select(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public boolean select(Viewer viewer, Object parentElement, Object element) {
			if (fRejectedElements != null) {
				for (int i= 0; i < fRejectedElements.length; i++) {
					if (element.equals(fRejectedElements[i])) {
						return false;
					}
				}
			}
			for (int i= 0; i < fAcceptedTypes.length; i++) {
				if (fAcceptedTypes[i].isInstance(element)) {
					return true;
				}
			}
			return false;
		}
	}
}
