/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.wst.server.core.IServer;


/**
 * @author rcernich
 *
 * Created on Jul 21, 2004
 */
public class DeployTarget implements IDeployTarget {

	private PackageConstructorExtension mConstructor;
	private IServer mServer;
	
	public DeployTarget(PackageConstructorExtension constructor,IServer server) {
		super();
		mConstructor = constructor;
		mServer = server;		
	}



	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IDeployTarget#supportsServer(org.eclipse.stp.soas.deploy.core.IServerType)
	 */
	public boolean supportsServer(IServerType serverType) {
		return mConstructor.supportsServer(serverType);
	}


	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IDeployTarget#getConnectionProfile()
	 */
	public IServer getServer() {
		return mServer;
	}

}
