/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import java.util.List;

import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyDefinition;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.deploy.core.IVersion;



/**
 * @author rcernich
 *
 * Created on Apr 9, 2004
 */
public class MergedSupportedTechnologyType implements ISupportedTechnologyType {

	private List mSupportedTechnologies;
	private ITechnologyDefinition mTechnologyDef;
	private IVersion mMinVersion;
	private IVersion mMaxVersion;

	public MergedSupportedTechnologyType(ISupportedTechnologyType istt1, ISupportedTechnologyType istt2) {
		super();
		if (istt1 == istt2) {
			throw new IllegalArgumentException("istt1 == istt2"); //$NON-NLS-1$
		}
		
		mTechnologyDef = istt1.getTechnologyDefinition();
		if (istt1.getMinVersion().compareTo(istt2.getMinVersion()) < 0) {
			mMinVersion = istt1.getMinVersion();
		}
		else {
			mMinVersion = istt2.getMinVersion();
		}
		if (istt1.getMaxVersion().compareTo(istt2.getMaxVersion()) > 0) {
			mMaxVersion = istt1.getMaxVersion();
		}
		else {
			mMaxVersion = istt2.getMaxVersion();
		}
		
		if (istt1 instanceof MergedSupportedTechnologyType) {
			mSupportedTechnologies.addAll(((MergedSupportedTechnologyType)istt1).getSupportedTechnologies());
		}
		else {
			mSupportedTechnologies.add(istt1);
		}
		if (istt2 instanceof MergedSupportedTechnologyType) {
			mSupportedTechnologies.addAll(((MergedSupportedTechnologyType)istt2).getSupportedTechnologies());
		}
		else {
			mSupportedTechnologies.add(istt2);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType#getTechnologyDefinition()
	 */
	public ITechnologyDefinition getTechnologyDefinition() {
		return mTechnologyDef;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType#getMinVersion()
	 */
	public IVersion getMinVersion() {
		return mMinVersion;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType#getMaxVersion()
	 */
	public IVersion getMaxVersion() {
		return mMaxVersion;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType#supportsTechnology(org.eclipse.stp.soas.deploy.core.ITechnologyType)
	 */
	public boolean supportsTechnology(ITechnologyType type) {
		boolean retVal;
		IVersion typeVersion = type.getVersion();
		if (!type.getTechnologyDefinition().equals(getTechnologyDefinition())
				|| typeVersion.compareTo(getMaxVersion()) > 0
				|| typeVersion.compareTo(getMinVersion()) < 0) {
			retVal = false;
		}
		else {
			retVal = true;
		}
		return retVal;
	}

	public List getSupportedTechnologies() {
		return mSupportedTechnologies;
	}

}
