/*******************************************************************************
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module;

import java.io.File;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.ModuleFactory;

/**
 * 
 * This class is used to work around the wtp tomcat server deploy limitation.
 * It only support deploy folder, but in stp, we want to deploy war file directly.
 * Two steps for tomcat deploy:
 * <li>update the server.xml</li>
 * It will add <context> node to server.xml, with following values:
 * <code>
 *   docBase = config.getDocBasePrefix() + module.getName();
 *   path = module.getPath
 * </code> 
 * <li>copy the deployable.</li>
 * The server code will copy the target war file to moduleName/you_file.war
 * 
 * Thus the default behavior will always generate wrong context node in server.xml
 * 
 * Instead of using Module class to always return module name, the
 * StpModule class will return ModuleName/hello_world.war if the getName() is called 
 * from TomcatServer:modifyModules method
 * 
 * @author jma
 */
public class StpModule extends Module {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(StpModule.class);
	
	
	private File warFile = null;
	
	public StpModule(ModuleFactory factory, String type, String version,
			IProject project, String name, String Id, File warFile) {
		super(factory, Id, name, type, version, project);
		this.warFile = warFile;
	}
	
	public File getDeployFile(){
		return warFile;
	}
	
	
	
}
