/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.EmptyContainerFilter;
import org.eclipse.stp.soas.internal.deploy.ui.PackagesFilter;
import org.eclipse.stp.soas.internal.deploy.ui.ProjectsFilter;
import org.eclipse.stp.soas.internal.deploy.ui.viewers.CheckboxTreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/**
 * @author rcernich
 * 
 * Created on Jan 28, 2004
 */
public class PackageSelectionWizardPage extends WizardPage implements
		ISummaryDataSource {

	public static final String LABEL_SELECT_PACKAGES;
	public static final int MIN_TREE_HEIGHT;

	private ProjectsFilter mProjectsFilter = new ProjectsFilter(null);
	private CheckboxTreeViewer mPackageViewer;
	private ISelection mSelection;

	/**
	 * @param pageName
	 */
	public PackageSelectionWizardPage(String pageName) {
		super(pageName);
	}

	/**
	 * @param pageName
	 * @param title
	 * @param titleImage
	 */
	public PackageSelectionWizardPage(String pageName, String title,
										ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}

	public void init(Root root, ISelection selection) {
		mSelection = selection;
	}

	public void setSourceProject(IProject sourceProject) {
		Object[] checked = mPackageViewer.getCheckedLeafElements();
		if (mProjectsFilter.setSourceProject(sourceProject)) {
			mPackageViewer.refresh();
			mPackageViewer.setCheckedElements(checked);
			validate();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		PackagesFilter packagesFilter = new PackagesFilter();

		Composite content = new Composite(parent, SWT.NULL);
		content.setLayout(new GridLayout(1, false));
		content.setLayoutData(new GridData(GridData.FILL_BOTH));

		Label label = new Label(content, SWT.NULL);
		label.setText(LABEL_SELECT_PACKAGES);
		GridData data = new GridData();
		label.setLayoutData(data);

		mPackageViewer = new CheckboxTreeViewer(content, SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.BORDER);
		mPackageViewer.setAutoExpandLevel(3);
		mPackageViewer.setContentProvider(new WorkbenchContentProvider());
		mPackageViewer.setLabelProvider(new WorkbenchLabelProvider());
		mPackageViewer.addFilter(packagesFilter);
		//mPackageViewer.addFilter(mProjectsFilter);
		mPackageViewer.addFilter(new EmptyContainerFilter());
		data = new GridData(GridData.FILL_BOTH);
		data.heightHint = mPackageViewer.getTree().getItemHeight()
				* MIN_TREE_HEIGHT;
		mPackageViewer.getTree().setLayoutData(data);
		mPackageViewer.addCheckStateListener(new ICheckStateListener() {

			public void checkStateChanged(CheckStateChangedEvent event) {
				handleCheckStateChanged(event);
			}
		});

		initControls();

		setControl(content);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#setVisible(boolean)
	 */
	public void setVisible(boolean visible) {
		if (visible) {
			// Update the packages view so that only applicable projects are
			// available.
			setSourceProject(((DeployFileNewWizard) getWizard())
					.getOutputFile().getProject());
		}
		super.setVisible(visible);
	}

	public IFile[] getSelection() {
		Object[] selection = mPackageViewer.getCheckedElements();
		Vector files = new Vector(selection.length);
		for (int index = 0, count = selection.length; index < count; ++index) {
			IResource res = (IResource) selection[index];
			int resType = res.getType();
			if (resType == IResource.FILE) {
				files.add(res);
			}
		}
		return (IFile[]) files.toArray(new IFile[files.size()]);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource#getSummaryData()
	 */
	public List getSummaryData() {
		IFile[] packages = getSelection();
		List summaryData = new ArrayList(packages.length + 1);

		summaryData.add(new String[] {
				DeployCorePlugin.getDefault().getResourceString(
						"PackageSelectionWizardPage.summary.selectedPackages"), //$NON-NLS-1$
				new String()});

		for (int index = 0, count = packages.length; index < count; ++index) {
			summaryData.add(new String[] { new String(),
					packages[index].getFullPath().toString()});
		}

		return summaryData;
	}

	private void initControls() {
		mPackageViewer.setInput(DeployCorePlugin.getWorkspace().getRoot());
		mPackageViewer.setCheckedElements(((IStructuredSelection) mSelection).toArray());
		updateControls();

		validate();
	}

	private void updateControls() {
		// Nothing to do here
	}

	private void validate() {
		if (getSelection().length > 0) {
			setMessage(null, WARNING);
		}
		else {
			setMessage(DeployCorePlugin.getDefault().getResourceString(
					"TEXT.NoPackagesWarning"), WARNING); //$NON-NLS-1$
		}
		setPageComplete(true);
	}

	private void handleCheckStateChanged(CheckStateChangedEvent event) {
		updateControls();

		validate();
	}

	static {
		LABEL_SELECT_PACKAGES = DeployCorePlugin.getDefault()
				.getResourceString("LABEL.SelectPackages"); //$NON-NLS-1$
		MIN_TREE_HEIGHT = 15;
	}

}