package org.eclipse.stp.soas.internal.deploy.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.soas.internal.deploy.ui.wizards.NewDeploymentProfileCreationPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class WorkspaceBasedDeployWizard extends Wizard implements INewWizard {

	private NewDeploymentProfileCreationPage deployPage;
	
	private final static String PROPERTY_DEPLOYMENT_VALUE = "deploymentProject";
	
	private final QualifiedName key = new QualifiedName("org.eclipse.stp","deploymentProject");
	
	public WorkspaceBasedDeployWizard() {
		// TODO Auto-generated constructor stub
	}

	@Override
	public boolean performFinish() {
		String name = deployPage.getName();
		IProject project = getDeploymentProject();
		if(project == null){
			project = createProject();
		}
		
		try {
			project.setPersistentProperty(key, PROPERTY_DEPLOYMENT_VALUE);
		} catch (CoreException e) {
			
		}
		return true;
	}



	public void init(IWorkbench workbench, IStructuredSelection selection) {
		// TODO Auto-generated method stub

	}
	
	public void addPages(){
		deployPage = new NewDeploymentProfileCreationPage("");
		addPage(deployPage);
	}

	private IProject getDeploymentProject() {

		IProject[] projects = ResourcesPlugin.getWorkspace().getRoot()
				.getProjects();
		try {
			for (int i = 0; i < projects.length; i++) {

				if(projects[i].getPersistentProperty(key) != null){
					return projects[i];
				}

			}
		} catch (CoreException e) {
			e.printStackTrace();
		}

		return null;
	}
	
	private IProject createProject() {
		return null;
	}
}
