/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf.handler;

import java.net.URL;

/**
 * This class provides common convenient methods for handler implementations. 
 */
public abstract class AbstractHandler implements IHandler {
	
	protected String kind = null;
	private String descKindName = null;
	private String name = null;
	private String description = null;
	private URL smallIcon = null;
	private URL largeIcon = null;
	
	final public void initialize(String kind, String descKindName, String name, String description, URL smallIcon, URL largeIcon) {
		this.kind = kind;
		this.descKindName = descKindName;
		this.name = name;
		this.description = description;
		this.smallIcon = smallIcon;
		this.largeIcon = largeIcon;
	}

	final public String getKind() {
		return kind;
	}
	
	final public String getDescriptiveKindName() {
		return descKindName;
	}
	
	final public String getName() {
		return name;
	}

	final public String getDescription() {
		return description;
	}

	final public URL getSmallIcon() {
		return smallIcon;
	}

	final public URL getLargeIcon() {
		return largeIcon;
	}

}
