/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.delete.operations;

import java.util.List;
import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class DeleteReferenceDataModelProvider extends
      AbstractScribblerDataModelProvider implements
      IDeleteReferenceDataModelProperties {

   public Set getPropertyNames() {
      Set propertyNames = super.getPropertyNames();
      propertyNames.add(COMPONENT_TYPE);
      propertyNames.add(REFERENCE_NAMES);
      return propertyNames;
   }

   public IStatus validate(String propertyName) {
      if (propertyName.equals(REFERENCE_NAMES)) {
         return validateReferenceNames();
      } else if (propertyName.equals(COMPONENT_TYPE)) {
         return validateComponent();
      }

      return super.validate(propertyName);
   }

   private IStatus validateComponent() {
      Object object = model.getProperty(COMPONENT_TYPE);

      if (object == null || !(object instanceof ComponentType))
         return STPCorePlugin.createErrorStatus(
               Messages.invalidObjectPassed_errorText, null);

      return OK_STATUS;
   }

   public IDataModelOperation getDefaultOperation() {
      return new DeleteReferenceOperation(model);
   }

   private IStatus validateReferenceNames() {
      ComponentType componentType = (ComponentType) model
            .getProperty(COMPONENT_TYPE);
      List references = componentType.getReferences();

      String[] referenceNames = (String[]) model
            .getProperty(IDeleteReferenceDataModelProperties.REFERENCE_NAMES);
      Assert.isTrue(references.size() >= referenceNames.length);
      for (int i = 0; i < referenceNames.length; i++) {
         Reference reference = null;

         for (int referenceIndex = 0; referenceIndex < references.size(); referenceIndex++) {
            reference = (Reference) references.get(referenceIndex);
            if (reference.getName().equals(referenceNames[i]))
               break;

            reference = null;
         }

         if (reference == null)
            return STPCorePlugin.createErrorStatus(NLS
                  .bind(Messages.referenceName_not_inComponentType,
                        referenceNames[i]), null);
      }

      return Status.OK_STATUS;
   }
}
