/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.introspection;

import org.eclipse.core.resources.IProject;
import org.eclipse.stp.core.infrastructure.emf.IResourceAssistant;
import org.eclipse.stp.core.infrastructure.emf.IResourceAssistantFactory;

/**
 * Taps into the Resource Assistant framework which allos clients to override
 * how resources are loaded.
 * 
 * Clients should have no reason to access this class.
 * 
 * @since 1.0
 * 
 */
public class ComponentTypeResourceAssistantFactory implements
      IResourceAssistantFactory {

   private static IResourceAssistantFactory instance = new ComponentTypeResourceAssistantFactory();

   /**
    * @return The singleton instance of this class.
    */
   public static IResourceAssistantFactory getInstance() {
      return instance;
   }

   public IResourceAssistant createResourceAssistant(IProject aProject) {
      return ComponentTypeResourceHandler.getInstance();
   }

}
