/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import java.util.List;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Reference Values Set</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.ReferenceValuesSet#getReferenceValues <em>Reference Values</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ReferenceValuesSet#getAnyAttribute <em>Any Attribute</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.ReferenceValuesSet#getComponent <em>Component</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getReferenceValuesSet()
 * @model extendedMetaData="name='ReferenceValuesSet' kind='elementOnly'"
 * @extends SCAObject
 * @generated
 */
public interface ReferenceValuesSet extends SCAObject {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Reference Values</b></em>'
    * containment reference list. The list contents are of type
    * {@link org.eclipse.stp.core.sca.ReferenceValue}. It is bidirectional and
    * its opposite is '{@link org.eclipse.stp.core.sca.ReferenceValue#getReferenceValueSet <em>Reference Value Set</em>}'.
    * <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Reference Values</em>' containment
    * reference list isn't clear, there really should be more of a description
    * here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Reference Values</em>' containment
    *         reference list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getReferenceValuesSet_ReferenceValues()
    * @see org.eclipse.stp.core.sca.ReferenceValue#getReferenceValueSet
    * @model type="org.eclipse.stp.core.sca.ReferenceValue"
    *        opposite="referenceValueSet" containment="true"
    *        resolveProxies="false" extendedMetaData="kind='element'
    *        name='reference'"
    * @generated
    */
   List getReferenceValues();

   /**
    * Returns the value of the '<em><b>Any Attribute</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any Attribute</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any Attribute</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getReferenceValuesSet_AnyAttribute()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='attributeWildcard'
    *        wildcards='##any' name=':1' processing='lax'"
    * @generated
    */
   FeatureMap getAnyAttribute();

   /**
    * Returns the value of the '<em><b>Component</b></em>' container
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Component</em>' container reference isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Component</em>' container reference.
    * @see #setComponent(Component)
    * @see org.eclipse.stp.core.sca.SCAPackage#getReferenceValuesSet_Component()
    * @model opposite="referenceValuesSet"
    * @generated
    */
   Component getComponent();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.ReferenceValuesSet#getComponent <em>Component</em>}'
    * container reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Component</em>' container
    *           reference.
    * @see #getComponent()
    * @generated
    */
   void setComponent(Component value);

} // ReferenceValuesSet
