/**
 * <copyright> </copyright>
 * 
 * $Id: ModuleComponentImpl.java,v 1.2 2006-04-05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.introspection.IModelIntrospectionManager;
import org.eclipse.stp.core.resources.SOAConstants;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.ModuleComponent;
import org.eclipse.stp.core.sca.ModuleImplementation;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Module Component</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleComponentImpl#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleComponentImpl#getModule <em>Module</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleComponentImpl#getUri <em>Uri</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleComponentImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ModuleComponentImpl extends ComponentImpl implements
      ModuleComponent {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String    copyright       = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap          any             = null;

   /**
    * The default value of the '{@link #getModule() <em>Module</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getModule()
    * @generated
    * @ordered
    */
   protected static final String MODULE_EDEFAULT = null;

   /**
    * The cached value of the '{@link #getModule() <em>Module</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getModule()
    * @generated
    * @ordered
    */
   protected String              module          = MODULE_EDEFAULT;

   /**
    * The default value of the '{@link #getUri() <em>Uri</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getUri()
    * @generated
    * @ordered
    */
   protected static final String URI_EDEFAULT    = null;

   /**
    * The cached value of the '{@link #getUri() <em>Uri</em>}' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getUri()
    * @generated
    * @ordered
    */
   protected String              uri             = URI_EDEFAULT;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap          anyAttribute    = null;

   /* Begin custom fields */

   /**
    * Provides an implementation of {@link ModuleImplementation} which directly
    * updates the obvious fields on the enclosing instance of
    * {@link ModuleComponent}.
    */
   public class ModuleImplementationImpl extends ImplementationImpl implements
         ModuleImplementation {

      public void setModule(String aModule) {
         ModuleComponentImpl.this.setModule(aModule);

      }

      public String getModule() {
         return ModuleComponentImpl.this.getModule();
      }

      public void setUri(String aUri) {
         ModuleComponentImpl.this.setUri(aUri);
      }

      public String getUri() {
         return ModuleComponentImpl.this.getUri();
      }

   }

   private ComponentType        componentType;

   private String               type           = SOAConstants.SCA_MODULE_TYPE;

   private ModuleImplementation implementation = new ModuleImplementationImpl();

   /* End custom fields */

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleComponentImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getModuleComponent();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this, SCAPackage.MODULE_COMPONENT__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getModule() {
      return module;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setModule(String newModule) {
      String oldModule = module;
      module = newModule;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.MODULE_COMPONENT__MODULE, oldModule, module));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getUri() {
      return uri;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setUri(String newUri) {
      String oldUri = uri;
      uri = newUri;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.MODULE_COMPONENT__URI, oldUri, uri));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.MODULE_COMPONENT__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseAdd(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.MODULE_COMPONENT__REFERENCE_VALUES_SET:
               if (referenceValuesSet != null)
                  msgs = ((InternalEObject) referenceValuesSet)
                        .eInverseRemove(
                              this,
                              EOPPOSITE_FEATURE_BASE
                                    - SCAPackage.MODULE_COMPONENT__REFERENCE_VALUES_SET,
                              null, msgs);
               return basicSetReferenceValuesSet((ReferenceValuesSet) otherEnd,
                     msgs);
            default:
               return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
         }
      }
      if (eContainer != null)
         msgs = eBasicRemoveFromContainer(msgs);
      return eBasicSetContainer(otherEnd, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.MODULE_COMPONENT__PROPERTY_VALUES_SET:
               return basicSetPropertyValuesSet(null, msgs);
            case SCAPackage.MODULE_COMPONENT__REFERENCE_VALUES_SET:
               return basicSetReferenceValuesSet(null, msgs);
            case SCAPackage.MODULE_COMPONENT__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.MODULE_COMPONENT__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_COMPONENT__PROPERTY_VALUES_SET:
            return getPropertyValuesSet();
         case SCAPackage.MODULE_COMPONENT__REFERENCE_VALUES_SET:
            return getReferenceValuesSet();
         case SCAPackage.MODULE_COMPONENT__NAME:
            return getName();
         case SCAPackage.MODULE_COMPONENT__ANY:
            return getAny();
         case SCAPackage.MODULE_COMPONENT__MODULE:
            return getModule();
         case SCAPackage.MODULE_COMPONENT__URI:
            return getUri();
         case SCAPackage.MODULE_COMPONENT__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_COMPONENT__PROPERTY_VALUES_SET:
            setPropertyValuesSet((PropertyValuesSet) newValue);
            return;
         case SCAPackage.MODULE_COMPONENT__REFERENCE_VALUES_SET:
            setReferenceValuesSet((ReferenceValuesSet) newValue);
            return;
         case SCAPackage.MODULE_COMPONENT__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.MODULE_COMPONENT__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_COMPONENT__MODULE:
            setModule((String) newValue);
            return;
         case SCAPackage.MODULE_COMPONENT__URI:
            setUri((String) newValue);
            return;
         case SCAPackage.MODULE_COMPONENT__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_COMPONENT__PROPERTY_VALUES_SET:
            setPropertyValuesSet((PropertyValuesSet) null);
            return;
         case SCAPackage.MODULE_COMPONENT__REFERENCE_VALUES_SET:
            setReferenceValuesSet((ReferenceValuesSet) null);
            return;
         case SCAPackage.MODULE_COMPONENT__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.MODULE_COMPONENT__ANY:
            getAny().clear();
            return;
         case SCAPackage.MODULE_COMPONENT__MODULE:
            setModule(MODULE_EDEFAULT);
            return;
         case SCAPackage.MODULE_COMPONENT__URI:
            setUri(URI_EDEFAULT);
            return;
         case SCAPackage.MODULE_COMPONENT__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_COMPONENT__PROPERTY_VALUES_SET:
            return propertyValuesSet != null;
         case SCAPackage.MODULE_COMPONENT__REFERENCE_VALUES_SET:
            return referenceValuesSet != null;
         case SCAPackage.MODULE_COMPONENT__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.MODULE_COMPONENT__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.MODULE_COMPONENT__MODULE:
            return MODULE_EDEFAULT == null ? module != null : !MODULE_EDEFAULT
                  .equals(module);
         case SCAPackage.MODULE_COMPONENT__URI:
            return URI_EDEFAULT == null ? uri != null : !URI_EDEFAULT
                  .equals(uri);
         case SCAPackage.MODULE_COMPONENT__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (any: "); //$NON-NLS-1$
      result.append(any);
      result.append(", module: "); //$NON-NLS-1$
      result.append(module);
      result.append(", uri: "); //$NON-NLS-1$
      result.append(uri);
      result.append(", anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

   /* ***** Begin Custom API **** */

   public ComponentType resolveComponentType() {
      if (componentType != null)
         return componentType;
      synchronized (this) {

         Assert
               .isTrue((eResource() != null && eResource().getResourceSet() != null));

         if (componentType == null && getModule() != null) {
            componentType = SCAFactory.eINSTANCE.createComponentType();
            Resource containingResource = eResource();
            URI moduleURI = URI.createURI(getModule());
            /*
             * fetch the platform:/resource/path/to/<resource>.subsystem as
             * /resource/path..
             */
            IPath localPath = new Path(containingResource.getURI().path());
            /* remove 'resource' but leave the leading '/' */
            localPath = localPath.removeFirstSegments(1).makeAbsolute();
            URI localURI = URI.createURI("comptype:" + localPath.toString()); //$NON-NLS-1$
            moduleURI = moduleURI.resolve(localURI);
            IModelIntrospectionManager.eINSTANCE.bind(componentType, moduleURI);
         }
      }
      return componentType;

   }

   public int getState() {
      if (getModule() == null)
         return STATE_ABSTRACT;
      return STATE_IMPLEMENTED;
   }

   public String getType() {
      return type;
   }

   /**
    * Only accepts instances of ModuleImplementation. Other attempts will
    * generate assertion failures and will not override the current
    * implementation.
    * 
    * {@inheritDoc}
    */
   public Implementation setSpecializedImplementation(
         Implementation newImplementation) {
      Assert.isLegal(newImplementation instanceof ModuleImplementation);
      ModuleImplementation oldImplementation = (ModuleImplementation) getImplementation();
      ModuleImplementation newModuleImplementation = (ModuleImplementation) newImplementation;

      oldImplementation.setModule(newModuleImplementation.getModule());
      oldImplementation.setUri(newModuleImplementation.getUri());

      return oldImplementation;
   }

   public Implementation setAbstractImplementation(ComponentType aComponentType) {
      STPCorePlugin
            .log(
                  IStatus.WARNING,
                  0,
                  "ModuleComponentImpl.setAbstractImplementation(ComponentType) not yet implementated.", null); //$NON-NLS-1$
      return null;
   }

   public Implementation getImplementation() {
      return implementation;
   }

   public void eSetProxyURI(URI uri) {
      disposeComponentType();
      super.eSetProxyURI(uri);
   }

   private void disposeComponentType() {
      synchronized (this) {
         if (componentType == null)
            return;
         IModelIntrospectionManager.eINSTANCE.unbind(componentType);
         componentType = null;
      }
   }

} // ModuleComponentImpl
