/**
 * <copyright> </copyright>
 * 
 * $Id: ModuleWireImpl.java,v 1.2 2006-04-05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.ModuleWire;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Module Wire</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleWireImpl#getSourceUri <em>Source Uri</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleWireImpl#getTargetUri <em>Target Uri</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleWireImpl#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ModuleWireImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ModuleWireImpl extends SCAInternalObjectImpl implements ModuleWire {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String    copyright           = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The default value of the '{@link #getSourceUri() <em>Source Uri</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getSourceUri()
    * @generated
    * @ordered
    */
   protected static final String SOURCE_URI_EDEFAULT = null;

   /**
    * The cached value of the '{@link #getSourceUri() <em>Source Uri</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getSourceUri()
    * @generated
    * @ordered
    */
   protected String              sourceUri           = SOURCE_URI_EDEFAULT;

   /**
    * The default value of the '{@link #getTargetUri() <em>Target Uri</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getTargetUri()
    * @generated
    * @ordered
    */
   protected static final String TARGET_URI_EDEFAULT = null;

   /**
    * The cached value of the '{@link #getTargetUri() <em>Target Uri</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getTargetUri()
    * @generated
    * @ordered
    */
   protected String              targetUri           = TARGET_URI_EDEFAULT;

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap          any                 = null;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap          anyAttribute        = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ModuleWireImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getModuleWire();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getSourceUri() {
      return sourceUri;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setSourceUri(String newSourceUri) {
      String oldSourceUri = sourceUri;
      sourceUri = newSourceUri;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.MODULE_WIRE__SOURCE_URI, oldSourceUri, sourceUri));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getTargetUri() {
      return targetUri;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setTargetUri(String newTargetUri) {
      String oldTargetUri = targetUri;
      targetUri = newTargetUri;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.MODULE_WIRE__TARGET_URI, oldTargetUri, targetUri));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this, SCAPackage.MODULE_WIRE__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.MODULE_WIRE__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.MODULE_WIRE__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.MODULE_WIRE__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_WIRE__SOURCE_URI:
            return getSourceUri();
         case SCAPackage.MODULE_WIRE__TARGET_URI:
            return getTargetUri();
         case SCAPackage.MODULE_WIRE__ANY:
            return getAny();
         case SCAPackage.MODULE_WIRE__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_WIRE__SOURCE_URI:
            setSourceUri((String) newValue);
            return;
         case SCAPackage.MODULE_WIRE__TARGET_URI:
            setTargetUri((String) newValue);
            return;
         case SCAPackage.MODULE_WIRE__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.MODULE_WIRE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_WIRE__SOURCE_URI:
            setSourceUri(SOURCE_URI_EDEFAULT);
            return;
         case SCAPackage.MODULE_WIRE__TARGET_URI:
            setTargetUri(TARGET_URI_EDEFAULT);
            return;
         case SCAPackage.MODULE_WIRE__ANY:
            getAny().clear();
            return;
         case SCAPackage.MODULE_WIRE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.MODULE_WIRE__SOURCE_URI:
            return SOURCE_URI_EDEFAULT == null ? sourceUri != null
                  : !SOURCE_URI_EDEFAULT.equals(sourceUri);
         case SCAPackage.MODULE_WIRE__TARGET_URI:
            return TARGET_URI_EDEFAULT == null ? targetUri != null
                  : !TARGET_URI_EDEFAULT.equals(targetUri);
         case SCAPackage.MODULE_WIRE__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.MODULE_WIRE__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (sourceUri: "); //$NON-NLS-1$
      result.append(sourceUri);
      result.append(", targetUri: "); //$NON-NLS-1$
      result.append(targetUri);
      result.append(", any: "); //$NON-NLS-1$
      result.append(any);
      result.append(", anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

} // ModuleWireImpl
