/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core;

import java.lang.reflect.Method;
import java.util.ArrayList;

/**
 * 
 * @author amiguel
 * 
 * Probably obsolete.
 * 
 * Part of the generic runtime engine API, a thread which uses reflection to 
 * run part of an engine Program.
 */
public class DataThread extends Thread {

private static Class[] form = new Class[]{ArrayList.class};

Method runmethod;
Method[] possibles;
Object[] args;
Object instance;

	public DataThread(Object program, String method, ArrayList data) throws Exception {
		init(program.getClass(),program,form,method,new Object[]{args});
	}

	public void init(Class clazz, Object object, Class[] form, String method, Object[] args) throws NoSuchMethodException {

		try {
			runmethod = clazz.getDeclaredMethod(method,form);

		} catch (NoSuchMethodException e) {
			
			Method[] methods = clazz.getDeclaredMethods();
			
			int count = 0;
			
			for (int i = 0; i < methods.length; i++) {
				
				if (methods[i].getName().equals(method)
					&& methods[i].getParameterTypes().length == args.length) {

					count++;
				} else {

					methods[i] = null;	
				}
			}
			
			Method[] tmp = new Method[count];
			count = 0;
			for (int i = 0; i < methods.length; i++) {
				if (methods[i] != null) {
					tmp[count++] = methods[i];
				}
			}
			
			//list of possible methods
			methods = tmp;

			long[] score = new long[methods.length];
			long maxscore = -999999;
			int index = 0;

			for (int i = 0; i < methods.length; i++) {
				Class[] params = methods[i].getParameterTypes();
				
//				Logger.info("Checking "+methods[i]);
				
				for (int k = 0; k < params.length; k++) {
					if (params[k] == form[k]) {
						score[i] += 10000;	
					} else if (params[k].isAssignableFrom(form[k])) {
						score[i] += 10000;	
					} else if (partialMatch(params[k],form[k])) {
						score[i] += 1;	
					} else {
						//a complete mismatch = no good
						score[i] = Long.MIN_VALUE;
						break;
					}
				}
					
				if (score[i] > maxscore) {
					maxscore = score[i];
					index = i;	
				}
					
			}
			
			if (maxscore < 0) {
				throw new NoSuchMethodException("method not found");	
			} 
			
			runmethod = methods[index];
		}	

		this.instance = object;
		this.args = args;			
	}

	private boolean partialMatch(Class param, Class arg) {
		if (param == int.class && arg == Integer.class) {
			return true;
		} else if (param == long.class && arg == Long.class) {
			return true;
		} else if (param == double.class && arg == Double.class) {
			return true;
		} else if (param == boolean.class && arg == Boolean.class) {
			return true;
		} else if (param == float.class && arg == Float.class) {
			return true;
		} else if (param == short.class && arg == Short.class) {
			return true;
		} else if (param == char.class && arg == Character.class) {
			return true;
		} else if (param == byte.class && arg == Byte.class) {
			return true;
		} 	
		return false;
	}

	Throwable return_exception;
	
	public Throwable getException() {
		return return_exception;	
	}
	
	public void run() {
		try {
			runmethod.invoke(instance,args); 
		} catch (Throwable t) {
			return_exception = t;	
		}
	}
	

}