/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core.bpel;

import org.eclipse.stp.b2j.core.jengine.internal.utils.XPathAccessible;


/**
 * 
 * @author amiguel
 * 
 * Part of the generic runtime engine API, used to help implement BPEL correlation sets.
 */
public class BPELCorrelationToken {
	
	String name;
	String value;
	
/*	public BPELCorrelationToken(String name, String value) {
		this.name = name;
		this.value = value;
	}*/
	public BPELCorrelationToken(String name, XPathAccessible value_source) throws Exception {
		this.name = name;
		this.value = value_source.getBpelProperty(name).get(0).getValue().toXpathStringValue();
	}
	
	public String getName() {
		return name;
	}
	public String getValue() {
		return value;
	}
	
	public void toString(StringBuffer sb) {
		sb.append("[CTOKNAME]");
		sb.append(name);
		sb.append("[CTOKVALUE]");
		sb.append(value);
	}
	
	public String toString() {
		StringBuffer sb = new StringBuffer();
		toString(sb);
		return sb.toString();
	}

	public boolean matches(XPathAccessible match) throws Exception {
		return value.equals(match.getBpelProperty(name).get(0).getValue().toXpathStringValue());
	}
}