/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.sessiontransport.tcpip;

//import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransport;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransportProvider;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

/**
 * 
 * @author amiguel
 *
 * The TCPIP Transport provider class.
 */
public class TCPIPTransportProvider implements SessionTransportProvider {

	public String getHumanReadableTypeName() {
		return "Sockets (TCP/IP)";
//		return B2jPlugin.getString("TCPIP_TRANSPORT_NAME");
	}
	public String getProviderClassName() {
		return getClass().getName();
	}
	public SessionTransport newInstance(SessionAddress address, boolean initiator) throws Exception {
		return new TCPIPTransport(address,initiator);
	}
/*	public String getProviderPluginName() {
		return B2jPlugin.getDefault().getBundle().getSymbolicName();
	}*/
	public boolean supportsEncryption() {
		return false;
	}
	public boolean supportsAuthentication() {
		return false;
	}
}