/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.eclipse.stp.b2j.core.jengine.internal.core.Runner;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;

/**
 * 
 * @author amiguel
 *
 * A class to represent a single WSIF Java port (Java Object)
 */
public class WSIFJavaPort {
	
	public Object portImpl;
	public WSIFJavaPort(String clazz) throws Exception {
		if (clazz == null) throw new ClassNotFoundException("(null class string)");
		if (clazz.length() == 0) throw new ClassNotFoundException("(empty class string - zero length)");
		
		try {
			//try to load via system classloader
			portImpl = Class.forName(clazz).newInstance();
		} catch (Exception e) {
		}

		if (portImpl == null) {
			//try to load via program classloader
			Thread t = Thread.currentThread();
			if (t instanceof Runner) {
				try {
					portImpl = ((Runner)t).getProgramClassLoader().loadClass(clazz).newInstance();
				} catch (ClassNotFoundException e) {
					throw new ClassNotFoundException("(could not load Java class to implement WSIF port - "+e.getMessage()+")",e);
				}
			}
		}

		System.out.println("NEW JAVA PORT "+clazz);
	}
	public Object getPortImplementation() {
		return portImpl;
	}
	public Object invoke(String methodName, Object[] args) throws Exception {
		
		Method method = null;
//		Object[] method_args = null;
		boolean matchedName = false;
		boolean matchedLen = false;
		
		Class clazz = portImpl.getClass();

		while (clazz != null && method == null) {
		
			Method[] methods = clazz.getDeclaredMethods();
			
			for (int i = 0; i < methods.length; i++) {
				String mname = methods[i].getName();
				if (mname.equals(methodName)) {
					matchedName = true;
					
					Class[] argtypes = methods[i].getParameterTypes();
					if (argtypes.length == args.length) {
						matchedLen = true;
						
						//EXTRA CHECK - CHECK ARGUMENT TYPES
						method = methods[i];
//						method_args = new Object[args.length];
						
						for (int k = 0; k < argtypes.length && method != null; k++) {
							
							if (!argtypes[k].isAssignableFrom(args[k].getClass())) {
								//this type doesn't match
								if (!(args[k] instanceof Number && argtypes[k].isPrimitive())
									&& !(args[k] instanceof Boolean && argtypes[k].isPrimitive())
									) {
									//even when we take into account this special case
									method = null;
								}
							}
/*							
							if (argtypes[k].isArray()) {
								//we are assigning into an array
								method_args[k] = args[k];

//								if (!argtypes[k].isAssignableFrom(args[k].getClass())) {
//									//this type doesn't match
//									method = null;
//								}
								
							} else {
								//we are assigning into a non-array value
								if (Array.getLength(args[k]) == 0) {
									method_args[k] = null;
								} else {
									method_args[k] = Array.get(args[k],0);
									
									if (!argtypes[k].isAssignableFrom(args[k].getClass())) {
										//this type doesn't match
										if (!(args[k] instanceof Number && argtypes[k].isPrimitive())) {
											//even when we take into account this special case
											method = null;
										}
									}
								}
							}*/
						}
						//END EXTRA CHECK
						
						
					}
				}
			}
			
			clazz = clazz.getSuperclass();
		}
		
		if (method != null) {
			try {
				return method.invoke(portImpl,args);
			} catch (InvocationTargetException e) {
				if (e.getTargetException() instanceof Exception) {
					throw (Exception)e.getTargetException();
				} else {
					throw new Exception("(Exception wrapped throwable) "+Logger.getStackTrace(e.getTargetException()));
				}
			}
		} else {
			if (matchedName && matchedLen) {
				throw new Exception("Could not find method "+methodName+" variant with appropriate argument types");
			} else if (matchedName) {
				throw new Exception("Could not find method "+methodName+" variant with "+args.length+" arguments");
			} else {
				throw new Exception("Could not find method with name "+methodName+" in class "+portImpl.getClass().getName());
			}
		}
	}
}