/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface;

/**
 * 
 * @author amiguel
 *
 * A WSIF Java port implementing a workbench host finding port
 */
public class WorkbenchHostPort {
	
	public String getWorkbenchHost() {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;
			try {
				return engine.getClientHost();
			} catch (Exception e) {
				return "ERROR: "+e;
			}
		} else {
			return "localhost";
		}
	}
}