/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mutex;

/**
 * 
 * @author amiguel
 * 
 * A Mutex implementation which does no queueing
 */
public class UnqueuedMutex {

Object LOCK = new Object();

private int val = 1;

public UnqueuedMutex() {
}

/**
 * 
 * @return true if the mutex was successfully locked
 */
public boolean testAndLock() {
	synchronized(LOCK) {
		if (val > 0) {
			//we won't block, so lock the mutex
			lock();
			return true;
		} else {
			return false;	
		}
	}	
}

public void lock() {
	synchronized(LOCK) {
		val--;
		try {
			if (val < 0) {
				LOCK.wait();
			}	
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
}

public void release() {
	synchronized(LOCK) {
		val++;
		if (val > 1) val = 1; 
		if (val <= 0) LOCK.notify();
	}
}

public static void main(String[] args) {

	double MAX = 10;
	
	UnqueuedMutex mutex = new UnqueuedMutex();
	double t = System.currentTimeMillis()+(1000.0d*MAX);
	double count = 0;
	while (System.currentTimeMillis() < t) {
		mutex.lock();
		
		count++;
			
		mutex.release();
	}
	
	System.out.println("UnqueuedMutex: "+(count/MAX)+" per second");

	Object lock = new Object();
	t = System.currentTimeMillis()+(1000.0d*MAX);
	count = 0;
	while (System.currentTimeMillis() < t) {
		synchronized(lock) {

			count++;
	
		}
	}
	
	System.out.println("sychronized keyword: "+(count/MAX)+" per second");
	
}

}
