/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mutex;

/**
 * 
 * @author amiguel
 * 
 * A semaphore implementation which does no queuing
 */
public class UnqueuedSemaphore {

Object LOCK = new Object();

private int val;

public UnqueuedSemaphore(int initial) {
	val = initial-1;
}

public void doWait(int count) {
	synchronized(LOCK) {
		for (int i = 0; i < count; i++) {
			val--;
			try {
				if (val < 0) {
					LOCK.wait();
				}	
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
}

public void doSignal(int count) {
	synchronized(LOCK) {
		for (int i = 0; i < count; i++) {
			val++;
			if (val <= 0) LOCK.notify();
		}
	}
}

}
