/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.ui.internal.debug;

import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.debug.DebugConstants;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * 
 * @author amiguel
 *
 * BPEL debugger stack trace follower - keeps track of stack info for threads in
 * the BPEL engine
 */
public class ControllerStackTracker implements TraceListener {
	public ControllerInterface engine;
	
	Object stacks_LOCK = new Object();
	HashMap stacks = new HashMap();
	
	public ControllerStackTracker(ControllerInterface cint) {
		this.engine = cint;
		engine.addTraceListener(this);
	}

	public Message getStack(String id) {
		synchronized(stacks_LOCK) {
			return (Message)stacks.get(id);
		}
	}
	
	public void trace(Message m) {
		if (m.getType() == DebugConstants.STACKTRACE_MSG_ID) {
			String threadId = null;
			Message variables = null;
			for (int i = 0; i < m.length(); i++) {
				if (m.get(i) instanceof Message) {
					Message sub = (Message)m.get(i);
					System.out.println(sub);
					if (sub.getType() == DebugConstants.STACKTRACE_THREAD_NAME) {
						threadId = (String)sub.get(0);
//					} else if (sub.getType() == DebugConstants.STACKTRACE_VARIABLES) {
//						variables = sub;
//System.out.println("GOT VARIABLES STACKTRACE "+sub);						
					}
				}
			}
			if (threadId != null) {
				synchronized(stacks_LOCK) {
					stacks.put(threadId,m);
				}
			} else {
				System.out.println("Stack trace with no thread name!");
			}
//			System.out.println(m);
		}
	}
	public void print(String s) {}
	public void debug(String s) {}
}