/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.ui.internal.debug;

import java.util.ArrayList;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * 
 * @author amiguel
 *
 * Represents a stackframe in a runner in the engine
 */
public class RunnerDebugVariableValue extends ControllerDebugElement implements IValue {

	Message value;
	String type;
	String xml;
	
	ArrayList variables = new ArrayList();
	
	public RunnerDebugVariableValue(RunnerDebugVariable var, Message value) {
		super((ControllerDebugTarget)var.getDebugTarget());
		this.value = value;
		
		type = (String)value.get(0);
		type = type.substring(type.indexOf("xmlns.")+"xmlns.".length());
		
		xml = parse(value);
	}
	
	private String parse(Message value) {
		StringBuffer sb = new StringBuffer();
		
		int index = 0;
		
		//type name (ignored)
		String type = (String)value.get(index++);
		
		String classname = type.substring(type.lastIndexOf('.')+1+NamespaceTranslator.getJavaClassName("").length());
		
		//tag name
		index++; //ignore 'TAG'
		String tag = (String)value.get(index++);
		if (tag == null) tag = classname;
		if (tag.equals("null")) tag = classname;
		sb.append("<");
		sb.append(tag);
		
		if (String.valueOf(value.get(index)).equalsIgnoreCase("ATTRIBUTES")) {
			index++;
			
			int len = ((Integer)value.get(index++)).intValue();
			for (int i = 0; i < len*2; i+=2) {
				String name = (String)value.get(index++);
				Message attrvalue = (Message)value.get(index++);

				sb.append(" "+name+"=\"");
				sb.append(parse(attrvalue));
				sb.append("\"");
			}
		}

		sb.append(">");
		
		if (String.valueOf(value.get(index)).equalsIgnoreCase("ELEMENTS")) {
			index++;
			
			int len = ((Integer)value.get(index++)).intValue();
			for (int i = 0; i < len; i++) {
				Message elemvalue = (Message)value.get(index++);
				
				sb.append(parse(elemvalue));
			}
		}
		
		if (String.valueOf(value.get(index)).equalsIgnoreCase("VALUE")) {
			index++;
			
			sb.append(String.valueOf(value.get(index++)));
		}
		
		sb.append("</");
		sb.append(tag);
		sb.append(">");
		
		xml = sb.toString();
		
		return xml;
	}

	public String getReferenceTypeName() throws DebugException {
		// TODO Auto-generated method stub
		return "unknown";
	}

	public String getValueString() throws DebugException {
//		return value.toString();
		return xml;
	}

	public boolean isAllocated() throws DebugException {
		// TODO Auto-generated method stub
		return false;
	}

	public IVariable[] getVariables() throws DebugException {
		IVariable[] vars = new IVariable[variables.size()];
		variables.toArray(vars);
		return vars;
	}

	public boolean hasVariables() throws DebugException {
		return variables.size() > 0;
	}

}