/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.sca.java.wizards;

import java.util.Hashtable;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.sc.sca.java.ScaJavaResources;
import org.eclipse.stp.sc.sca.java.workspace.ScaWorkspaceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

/**
 * @author jma
 *
 */
public class ScaWSBindingWizardPage extends ScaBindingPage {
	
	ScaJavaProjectWizard scaWizard;
	ScaWSBindingPageComposite composite;
	
	protected ScaWSBindingWizardPage(String pageName, ScaJavaProjectWizard wizard) {
		super(pageName);
		setTitle(ScaJavaResources.getString("wizard.project.generalpage.title"));
		setDescription("Set WebService binding information");
		ImageDescriptor banner = ScaJavaResources.getImageDescriptor("wizban/sca_wiz.gif");
        setImageDescriptor(banner);
		scaWizard = wizard;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.sc.sca.java.wizards.ScaBindingPage#getBindingAttrs()
	 */
	@Override
	protected Hashtable<String, String> getBindingAttrs() {
		Hashtable<String, String> attrs = new Hashtable<String, String>();
        /*
		String endPoint = composite.txtURL.getText()
            + "#wsdl.endpoint(";
        endPoint += composite.txtService.getText();
        endPoint += "/";
        endPoint += composite.txtPort.getText() + ")";
        attrs.put("endpoint", endPoint);
        attrs.put("location", composite.txtWsdlLocation.getText());
        */
        attrs.put("uri", composite.txtURL.getText());
        return attrs;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		composite = new ScaWSBindingPageComposite(parent, 
				SWT.NULL);
		this.setControl(composite);
		composite.txtURL.addModifyListener(new TextModifyAdapter());
		composite.txtService.addModifyListener(new TextModifyAdapter());
		composite.txtPort.addModifyListener(new TextModifyAdapter());
	
	}
	
	public void setVisible(boolean visible) {
        super.setVisible(visible);
        String scaServiceName = scaWizard.compPage.composite.txtInterface.getText();
		composite.txtURL.setText(ScaWorkspaceManager.getDefaultWSUrl(
				scaServiceName));
		composite.txtService.setText(ScaWorkspaceManager.getDefaultWSServiceName(
				scaServiceName));
		composite.txtPort.setText(ScaWorkspaceManager.getDefaultWSPortName(
				scaServiceName));
		
		composite.txtWsdlLocation.setText("resources/wsdl/" + scaServiceName.toLowerCase() + ".wsdl");
    }
	
	private boolean validatePage() {
		setMessage(null);
		setErrorMessage(null);
		if (composite.txtURL.getText() == null
				|| composite.txtURL.getText().equals("")) {
			setErrorMessage("URL can't be empty");
			return false;
		}
		if (composite.txtPort.getText() == null
				|| composite.txtPort.getText().equals("")) {
			setErrorMessage("port can't be empty");
			return false;
		}
		if (composite.txtService.getText() == null
				|| composite.txtService.getText().equals("")) {
			setErrorMessage("Service name can't be empty");
			return false;
		}
        return true;
	}

	class TextModifyAdapter implements ModifyListener {
		public void modifyText(ModifyEvent e) {
			setPageComplete(validatePage());
		}
	}
}
