/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.emf.controls;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;

/**
 * @author rcernich
 * 
 * Created on Oct 13, 2004
 */
public class EMFCheckboxControl extends EMFControl {

	/**
	 * @param control
	 * @param domain
	 * @param feature
	 */
	public EMFCheckboxControl(Button control, EStructuralFeature feature) {
		super(control, feature);
	}

	public Button getButtonControl() {
		return (Button) getControl();
	}

	public boolean getSelection() {
		return getButtonControl().getSelection();
	}

	public void setSelection(boolean selection) {
		getButtonControl().setSelection(selection);
		// setSelection() does not generate a selection event.
		getButtonControl().notifyListeners(SWT.Selection,null);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.emf.controls.EMFControl#getControlValue()
	 */
	public Object getControlValue() {
		return Boolean.valueOf(getSelection());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.emf.controls.EMFControl#setControlValue(java.lang.Object)
	 */
	public void setControlValue(Object value) {
		if (value == null) {
			// Should be reasonable
			value = Boolean.FALSE;
		}
		setSelection(((Boolean) value).booleanValue());
	}

}