/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.generators;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.cxf.CXFResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IParameterPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CeltixWsdlToJavaParameterPage implements IParameterPage {

	public static final String KEY_BINDING_FILE_LIST = "KEY_BINDING_FILE_LIST";
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(CeltixWsdlToJavaParameterPage.class);

	Button btBindingFile = null;
	Text txtBindingFiles = null;
	Button btBrowse = null;
	Button btImpl = null;
	Button btServer = null;
	Button btClient = null;
	Button btExsh = null;
	Button btDns = null;
	Button btDex = null;
	Button btAnt = null;
	Button btVerbose = null;
	HashMap<String, Object> params = new HashMap<String, Object>();
	Shell parentShell = null;
	WizardPage hostPage = null;
	String wsdlUrl;

	public Control createContents(Composite parent) {
		parentShell = parent.getShell();
		Composite compBinding = new Composite(parent, SWT.NONE);
		compBinding.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		compBinding.setLayout(new GridLayout(2, false));

		btBindingFile = new Button(compBinding, SWT.CHECK);
		btBindingFile.setText(CXFResources.getString("Wsdl.To.Java.BindingFile.Checkbox.Text"));
		btBindingFile.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				txtBindingFiles.setEnabled(btBindingFile.getSelection());
				btBrowse.setEnabled(btBindingFile.getSelection());
				validateParams();
			}
		});
		
		new Text(compBinding, SWT.SINGLE | SWT.Hide).setVisible(false);
		
		txtBindingFiles = new Text(compBinding, SWT.SINGLE | SWT.BORDER);
		txtBindingFiles.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		txtBindingFiles.setEnabled(false);
		txtBindingFiles.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				validateParams();
			}
		});
		
		btBrowse = new Button(compBinding, SWT.PUSH);
		btBrowse.setText(CXFResources.getString("Wsdl.To.Java.Browse.Binding.Button"));
		btBrowse.setEnabled(false);
		btBrowse.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				LOG.debug("Browsing button is pressed");
				FileDialog fileChooser = new FileDialog(parentShell, SWT.OPEN | SWT.MULTI);
				String result = fileChooser.open();
				if (result != null) {
					String[] names = fileChooser.getFileNames();
					String path = fileChooser.getFilterPath();
					StringBuffer sbValue = new StringBuffer();
					for (int i = 0; i < names.length; ++i) {
						sbValue.append(path + names[i]);
						if (i < (names.length - 1)) {
							sbValue.append(", ");
						}
					}
					txtBindingFiles.setText(sbValue.toString());
				}
				validateParams();
			}
		});
		
		Group grpCodeGenCat = new Group(parent, SWT.NONE);
		grpCodeGenCat.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		grpCodeGenCat.setLayout(new GridLayout(3, true));
		grpCodeGenCat.setText(CXFResources.getString("Wsdl.To.Java.Code.Category.Group.Text"));
		
		btImpl = new Button(grpCodeGenCat, SWT.CHECK);
		btImpl.setText(CXFResources.getString("Wsdl.To.Java.Code.Gen.Impl.Button"));
		btImpl.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (btImpl.getSelection()) {
					params.put(ToolConstants.WSDL2JAVA_PARA_GEN_IMPL, "");
				} else {
					params.remove(ToolConstants.WSDL2JAVA_PARA_GEN_IMPL);
				}
				validateParams();
			}
		});
		//default impl
		btImpl.setSelection(true);
		params.put(ToolConstants.WSDL2JAVA_PARA_GEN_IMPL, "");
		
		btServer = new Button(grpCodeGenCat, SWT.CHECK);
		btServer.setText(CXFResources.getString("Wsdl.To.Java.Code.Gen.Server.Button"));
		btServer.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (btServer.getSelection()) {
					params.put(ToolConstants.WSDL2JAVA_PARA_GEN_SERVER, "");
				} else {
					params.remove(ToolConstants.WSDL2JAVA_PARA_GEN_SERVER);
				}
				validateParams();
			}
		});
        btServer.setSelection(true);
        params.put(ToolConstants.WSDL2JAVA_PARA_GEN_SERVER, "");
		
		btClient = new Button(grpCodeGenCat, SWT.CHECK);
		btClient.setText(CXFResources.getString("Wsdl.To.Java.Code.Gen.Client.Button"));
		btClient.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (btClient.getSelection()) {
					params.put(ToolConstants.WSDL2JAVA_PARA_GEN_CLIENT, "");
				} else {
					params.remove(ToolConstants.WSDL2JAVA_PARA_GEN_CLIENT);
				}
				validateParams();
			}
		});
        btClient.setSelection(true);
        params.put(ToolConstants.WSDL2JAVA_PARA_GEN_CLIENT, "");
        
		Composite compOthers = new Composite(parent, SWT.NONE);
		compOthers.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		compOthers.setLayout(new GridLayout(1, false));
		
		btExsh = new Button(compOthers, SWT.CHECK);
		btExsh.setText(CXFResources.getString("Wsdl.To.Java.Other.Exsh.Text"));
		btExsh.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (btExsh.getSelection()) {
					params.put(ToolConstants.WSDL2JAVA_PARA_EXTEND_SOAP_HEADER, "");
				} else {
					params.remove(ToolConstants.WSDL2JAVA_PARA_EXTEND_SOAP_HEADER);
				}
				validateParams();
			}
		});
		btExsh.setSelection(true);
		params.put(ToolConstants.WSDL2JAVA_PARA_EXTEND_SOAP_HEADER, "");
		
		btDns = new Button(compOthers, SWT.CHECK);
		btDns.setText(CXFResources.getString("Wsdl.To.Java.Other.Dns.Text"));
		btDns.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (btDns.getSelection()) {
					params.put(ToolConstants.WSDL2JAVA_PARA_DEFAULT_NAMESPACE, "");
				} else {
					params.remove(ToolConstants.WSDL2JAVA_PARA_DEFAULT_NAMESPACE);
				}
				validateParams();
			}
		});
		btDns.setSelection(true);
		params.put(ToolConstants.WSDL2JAVA_PARA_DEFAULT_NAMESPACE, "");
		
		btDex = new Button(compOthers, SWT.CHECK);
		btDex.setText(CXFResources.getString("Wsdl.To.Java.Other.Dex.Text"));
		btDex.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (btDex.getSelection()) {
					params.put(ToolConstants.WSDL2JAVA_PARA_DEFAULT_EXCLUDE_NAMESPACE, "");
				} else {
					params.remove(ToolConstants.WSDL2JAVA_PARA_DEFAULT_EXCLUDE_NAMESPACE);
				}
				validateParams();
			}
		});
		btDex.setSelection(true);
		params.put(ToolConstants.WSDL2JAVA_PARA_DEFAULT_EXCLUDE_NAMESPACE, "");
		
		Label lbSep = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		lbSep.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		Composite compMisc = new Composite(parent, SWT.NONE);
		compMisc.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		compMisc.setLayout(new GridLayout(2, false));
		
		btAnt = new Button(compMisc, SWT.CHECK);
		btAnt.setText(CXFResources.getString("Wsdl.To.Java.Mist.Ant.Text"));
		btAnt.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (btAnt.getSelection()) {
					params.put(ToolConstants.WSDL2JAVA_PARA_GEN_ANT, "");
				} else {
					params.remove(ToolConstants.WSDL2JAVA_PARA_GEN_ANT);
				}
				validateParams();
			}			
		});
		
		btVerbose = new Button(compMisc, SWT.CHECK);
		btVerbose.setText(CXFResources.getString("Wsdl.To.Java.Mist.Verbose.Text"));
		btVerbose.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (btVerbose.getSelection()) {
					params.put(ToolConstants.WSDL2JAVA_PARA_VERBOSE, "");
				} else {
					params.remove(ToolConstants.WSDL2JAVA_PARA_VERBOSE);
				}
				validateParams();
			}			
		});
		
		return parent;
	}

	public Map<String, Object>  getParameters() {
		return params;
	}

	public void performOK() {
		if (btBindingFile.getSelection()) {
			String bFileStr = btBindingFile.getText();
			StringTokenizer tkzr = new StringTokenizer(bFileStr, ",");
			ArrayList<String> listFiles = new ArrayList<String>();
			while (tkzr.hasMoreTokens()) {
				String fPath = tkzr.nextToken();
				listFiles.add(fPath);
			}
			params.put(KEY_BINDING_FILE_LIST, listFiles);
		}
	}

	public void setInitializationData(IConfigurationElement config,
			String propertyName, Object data) throws CoreException {
		// TODO Auto-generated method stub

	}

	public String validateParams() {
		String result = null;
		if (btBindingFile.getSelection()) {
			if (this.txtBindingFiles.getText().trim().equals("")) {
				result = CXFResources.getString("Wsdl.To.Java.Param.Binding.File.Empty");
			} else {
				String bFileStr = txtBindingFiles.getText();
				StringTokenizer tkzr = new StringTokenizer(bFileStr, ",");
				while (tkzr.hasMoreTokens()) {
					String fPath = tkzr.nextToken();
					LOG.debug("File Path: " + fPath);
					File file = new File(fPath);
					if (!file.exists()) {
						result = CXFResources.getString("Wsdl.To.Java.Param.File.Not.Exist") + fPath;
						break;
					} else {
						if (file.isDirectory()) {
							result = CXFResources.getString("Wsdl.To.Java.Param.File.Is.Dir") + fPath;
							break;
						}
					}
				}
			}
		}
		if (result == null) {
			if ((!btImpl.getSelection()) && (!btServer.getSelection()) && (!btClient.getSelection())) {
				result = CXFResources.getString("Wsdl.To.Java.Param.No.Gen.Type");
			}
		}
		hostPage.setErrorMessage(result);
		hostPage.setPageComplete(result == null);
		return result;
	}

	public void setPage(WizardPage page) {
		hostPage = page;
	}
	
	public void setWsdlUrl(String url) {
		LOG.debug("set WsdlURL called:" + url);
	    wsdlUrl = url;	
	}

}
