/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.natures;

import java.util.ArrayList;
import java.util.Arrays;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;

/**
 * define a java first oriented nature as well as the necessary lifecycle methods to manage it
 */
public class CxfSimpleFrontendNature implements IProjectNature {

	public static final String NATURE_ID = "org.eclipse.stp.sc.cxf.natures.cxfSimpleFrontendNature";
    
    //private static final LoggingProxy LOG = LoggingProxy.getlogger(ScJavaFirstNature.class);
    
    private IProject theProject;
    
    public void configure() throws CoreException {
    }
    
    public void deconfigure() throws CoreException {
    }
    

    public IProject getProject() {
        return theProject;
    }

    public void setProject(IProject value) {
        this.theProject = value;
    }

    public static void addToProject(IProject project) throws CoreException {
        if (!project.hasNature(NATURE_ID)) {
            IProjectDescription desc = project.getDescription();
            String[] natures = desc.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
			System.arraycopy(natures, 0, newNatures, 1, natures.length);
			newNatures[0] = NATURE_ID;
            desc.setNatureIds(newNatures);
            project.setDescription(desc, null);
            
            //set up classpath based on the kit used
            String runtimeType = RuntimeCore.getRuntimeType(project);
            String runtimeId = RuntimeCore.getRuntimeID(project);
            IRuntimeKitProcessor kitProcessor = RuntimeProviderManager.getInstance().getRuntimeKitProcessor(runtimeType, runtimeId);
            if(kitProcessor != null){
            	kitProcessor.completeJavaProjectBuildPath(JavaCore.create(project));
            }
        }
    }

    public static void removeFromProject(IProject project) throws CoreException {
        if (project.hasNature(NATURE_ID)) {
            IProjectDescription desc = project.getDescription();
            String[] natures = desc.getNatureIds();
            ArrayList<String> newNatures = new ArrayList<String>(Arrays.asList(natures));
            newNatures.remove(newNatures.indexOf(NATURE_ID));
            desc.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
            project.setDescription(desc, null);
            
            // clean the build path based on the kit used
            String runtimeType = RuntimeCore.getRuntimeType(project);
            String runtimeId = RuntimeCore.getRuntimeID(project);
            IRuntimeKitProcessor kitProcessor = RuntimeProviderManager.getInstance().getRuntimeKitProcessor(runtimeType, runtimeId);
            if(kitProcessor != null){
            	kitProcessor.clearJavaProjectBuildPath(JavaCore.create(project));
            }

        }
    }

    public static boolean hasNature(IProject aProject) throws CoreException {
    	return aProject.hasNature(NATURE_ID);
        
    }
}
