/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.launchconfig;

import java.util.ArrayList;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;

public class LaunchConfigTabGroup extends AbstractLaunchConfigurationTabGroup {


	public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
		ArrayList tabs = new ArrayList(); 
        tabs.add(new LaunchConfigProviderTab()); 
//        tabs.add(new LaunchConfigAssetsTab()); 
        tabs.add(new LaunchConfigDistributionTab()); 
        tabs.add(new LaunchConfigTranslatorTab()); 
//        tabs.add(new LaunchConfigDependenciesTab()); 
        tabs.add(new CommonTab()); 

        ILaunchConfigurationTab[] alltabs = new ILaunchConfigurationTab[tabs.size()];
        tabs.toArray(alltabs); 
        setTabs(alltabs);
	}

}
