/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider;

/**
 * The main interface to implement when implementing a new BPELProvider.  
 * Provides a PropertySource based UI to configure the BPEL provider and
 * ultimately provides a BPEL run name, BPEL source file and a BPEL source
 * file base URI (for resolving relative imports)
 * 
 * @author amiguel
 */
public interface BPELProvider {
	public PropertySourceUI getPropertySourceUI();

	public void setPropertySource(PropertySource source);
	public String getBpelName() throws Exception;
	public String getBpelSource() throws Exception;
	public String getBpelUri() throws Exception;
	
}