/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.core.datapool;

import org.eclipse.stp.b2j.core.jengine.internal.core.SubControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.VariableTypeException;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

public class SharedVariable {
    public static final int NONE = -1;
    public static final int INTEGER = 0;
    public static final int LONG = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int STRING = 4;
    public static final int BYTES = 5;
    public static final int MESSAGE = 6;
    Object value = null;
    SubControllerInterface controller;
    int id;
    String name;
    int type = -1;

    public SharedVariable(SubControllerInterface controller, String name, int id, int type, Object value) {
        this.controller = controller;
        this.name = name;
        this.id = id;
        this.type = type;
        this.value = value;
    }

    public boolean isDirty() throws Exception {
        if (this.controller == null) {
            return false;
        }
        return this.controller.isVariableDirty(this.id);
    }

    public void varStore() throws Exception {
        if (this.controller == null) {
            return;
        }
        this.controller.storeVariable(this.id, this.type, this.value);
    }

    public void varFetch() throws Exception {
        if (this.controller == null) {
            return;
        }
        this.value = this.controller.fetchVariable(this.id, this.type);
    }

    public void setValue(int i) throws ClassCastException {
        this.setValue(new Integer(i));
    }

    public void setValue(long i) throws ClassCastException {
        this.setValue(new Long(i));
    }

    public void setValue(float i) throws ClassCastException {
        this.setValue(new Float(i));
    }

    public void setValue(double i) throws ClassCastException {
        this.setValue(new Double(i));
    }

    public void setValue(Object newval) throws ClassCastException {
        switch (this.type) {
            case 0: {
                this.value = new Integer(((Number)newval).intValue());
                break;
            }
            case 4: {
                this.value = (String)newval;
                break;
            }
            case 5: {
                this.value = (byte[])newval;
                break;
            }
            case 6: {
                this.value = (Message)newval;
                break;
            }
            case 1: {
                this.value = new Long(((Number)newval).longValue());
                break;
            }
            case 3: {
                this.value = new Double(((Number)newval).doubleValue());
                break;
            }
            case 2: {
                this.value = new Float(((Number)newval).floatValue());
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public int getValueInt() throws VariableTypeException {
        if (this.type == 4 || this.type == 5) {
            throw new VariableTypeException("attempted to get number value when variable is not a number");
        }
        return ((Number)this.value).intValue();
    }

    public long getValueLong() throws VariableTypeException {
        if (this.type == 4 || this.type == 5) {
            throw new VariableTypeException("attempted to get number value when variable is not a number");
        }
        return ((Number)this.value).longValue();
    }

    public float getValueFloat() throws VariableTypeException {
        if (this.type == 4 || this.type == 5) {
            throw new VariableTypeException("attempted to get number value when variable is not a number");
        }
        return ((Number)this.value).floatValue();
    }

    public double getValueDouble() throws VariableTypeException {
        if (this.type == 4 || this.type == 5) {
            throw new VariableTypeException("attempted to get number value when variable is not a number");
        }
        return ((Number)this.value).doubleValue();
    }

    public String getValueString() throws VariableTypeException {
        if (this.type != 4) {
            throw new VariableTypeException("attempted to get string value when variable is not a string");
        }
        return (String)this.value;
    }

    public byte[] getValueBytes() throws VariableTypeException {
        if (this.type != 5) {
            throw new VariableTypeException("attempted to get bytes value when variable is not a bytes");
        }
        return (byte[])this.value;
    }

    public Message getValueMessage() throws VariableTypeException {
        if (this.type != 6) {
            throw new VariableTypeException("attempted to get Message value when variable is not a Message");
        }
        return (Message)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

