/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.message.BPlaneServerThread;
import org.eclipse.stp.b2j.core.jengine.internal.message.MTTransactionClient;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageUtils;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerInputStream;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerOutputStream;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.UnqueuedMutex;

public class BPlaneTransactionClient
implements MTTransactionClient {
    MultiplexerOutputStream xout;
    MultiplexerInputStream xin;

    public BPlaneTransactionClient(InputStream bin, OutputStream bout, ThreadGroup tg, String name) {
        this.xin = new MultiplexerInputStream(bin, String.valueOf(name) + "_BufferPlaneClientIncomingMultiplexer", tg);
        this.xout = new MultiplexerOutputStream(bout, String.valueOf(name) + "_BufferPlaneClientOutgoingMultiplexer", tg);
    }

    public BPlaneTransactionClient(InputStream bin, OutputStream bout) {
        this.xin = new MultiplexerInputStream(bin, "BufferPlaneClientIncomingMultiplexer");
        this.xout = new MultiplexerOutputStream(bout, "BufferPlaneClientOutgoingMultiplexer");
    }

    public Message doTransaction(Message m) throws IOException {
        Thread thread;
        if (Switches.MESSAGES_WITH_CALLSTACK) {
            m.appendToCallStack(new Throwable("Message Callstack - transaction"));
        }
        if ((thread = Thread.currentThread()) instanceof BPlaneServerThread) {
            BPlaneServerThread bpthread = (BPlaneServerThread)thread;
            short plane = bpthread.plane;
            short p = 0;
            while (p <= plane + 1) {
                UnqueuedMutex mutex = this.xout.getLock(p);
                boolean locked = false;
                if (p == plane + 1) {
                    mutex = this.xout.getLock(p);
                    mutex.lock();
                    locked = true;
                } else {
                    locked = mutex.testAndLock();
                }
                if (locked) {
                    try {
                        OutputStream out = this.xout.getOutputStream(p);
                        InputStream in = this.xin.getInputStream(p);
                        MessageUtils.writeMessage(out, m);
                        m = MessageUtils.readMessage(in);
                    }
                    catch (IOException e) {
                        mutex.release();
                        throw e;
                    }
                    catch (Throwable e) {
                        mutex.release();
                        throw new IOException("Error performing transaction " + e);
                    }
                    mutex.release();
                    return m;
                }
                p = (short)(p + 1);
            }
        } else {
            OutputStream out = this.xout.getOutputStream((short)0);
            InputStream in = this.xin.getInputStream((short)0);
            UnqueuedMutex mutex = this.xout.getLock((short)0);
            mutex.lock();
            try {
                MessageUtils.writeMessage(out, m);
                m = MessageUtils.readMessage(in);
            }
            catch (IOException e) {
                mutex.release();
                throw e;
            }
            catch (Throwable e) {
                mutex.release();
                throw new IOException("Error performing transaction " + e);
            }
            mutex.release();
        }
        return m;
    }
}

