/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.stp.b2j.core.jengine.internal.core.DataThread;
import org.eclipse.stp.b2j.core.jengine.internal.core.PrintHandler;
import org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.SubControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELFault;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedHashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedBarrier;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedSemaphore;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.utils.FStack;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ID;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;

public class Runner
extends RunnerInterface {
    public static final int RUNNER_MAX_STACK = 200;
    public HashMap data = new HashMap();
    private FStack callstack = new FStack();
    public String stackname = null;
    int overStack = 0;
    private static final Class[] args = new Class[0];
    private static final Object[] oargs = new Object[0];
    Object program_instance;
    Method real_method;
    Method init_method;
    SubControllerInterface parent;
    long id;
    String[] hosts_cache = null;

    public void ipushStack(String stackline) throws Exception {
        if (this.stackname == null) {
            this.stackname = "  runner(" + Long.toHexString(this.id) + ")@" + this.getHost() + ":";
        }
        if (this.callstack.size() > 200) {
            ++this.overStack;
        } else {
            this.callstack.push(stackline);
        }
    }

    public void ipushStack(Message stackinfo) throws Exception {
        if (this.callstack.size() > 200) {
            ++this.overStack;
        } else {
            this.callstack.push(stackinfo);
        }
    }

    public void ipopStack() throws Exception {
        if (this.overStack > 0) {
            --this.overStack;
        } else {
            this.callstack.pop();
        }
    }

    public static void pushStack(Message stackinfo) {
        Thread thread = Thread.currentThread();
        if (thread instanceof Runner) {
            try {
                Runner r = (Runner)thread;
                r.ipushStack(stackinfo);
            }
            catch (Exception e) {
                Logger.error("Error adding to runner callstack", e);
            }
        }
    }

    public static void pushStack(String stackline) {
        Thread thread = Thread.currentThread();
        if (thread instanceof Runner) {
            try {
                Runner r = (Runner)thread;
                r.ipushStack(stackline);
            }
            catch (Exception e) {
                Logger.error("Error adding to runner callstack", e);
            }
        }
    }

    public static void popStack() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Runner) {
            Runner r = (Runner)thread;
            try {
                r.ipopStack();
            }
            catch (Exception e) {
                Logger.error("Error removing from runner callstack", e);
            }
        }
    }

    public Message getStackContents() {
        Message m = new Message();
        int i = 0;
        while (i < this.callstack.size()) {
            Object o = this.callstack.get(i);
            if (o instanceof String) {
                m.append((String)o);
            } else {
                m.append((Message)o);
            }
            ++i;
        }
        return m;
    }

    public void setStackContents(Message m) {
        this.callstack.clear();
        int i = 0;
        while (i < m.length()) {
            this.callstack.push(m.get(i));
            ++i;
        }
    }

    public String getStack() {
        StringBuffer sb = new StringBuffer();
        if (this.isAlive()) {
            sb.append("runner " + this.program_instance.getClass().getName() + "." + this.real_method.getName() + " started (ALIVE)\n");
        } else {
            sb.append("runner " + this.program_instance.getClass().getName() + "." + this.real_method.getName() + " started (NOW DEAD)\n");
        }
        int i = 0;
        while (i < this.callstack.size()) {
            if (this.callstack.get(i) instanceof String) {
                sb.append(this.stackname);
                sb.append((String)this.callstack.get(i));
                if (i < this.callstack.size() - 1) {
                    sb.append("\n");
                }
            }
            ++i;
        }
        if (this.overStack > 0) {
            sb.append("\n(STACK TRACE MAXIMUM REACHED - " + this.overStack + " more stackframes)");
        }
        return sb.toString();
    }

    public Runner(ThreadGroup group, String name, SubControllerInterface parent, long id, Class program, Object program_instance, String method) throws Exception {
        super(group, name);
        this.parent = parent;
        this.id = id;
        this.program_instance = program_instance;
        this.setFields();
        this.setMethod(method);
        this.setPriority(10);
    }

    public void setMethod(String method) throws Exception {
        this.getRealMethod(method);
    }

    private void setFields() throws Exception {
        Class<?> program = this.program_instance.getClass();
        Field runner = program.getDeclaredField("engine");
        runner.setAccessible(true);
        runner.set(this.program_instance, this);
    }

    private void getRealMethod(String method) throws Exception {
        Class<?> program = this.program_instance.getClass();
        this.real_method = program.getDeclaredMethod(method, args);
        this.init_method = program.getDeclaredMethod("engine_init", new Class[0]);
    }

    public void run() {
        Thread th = Thread.currentThread();
        try {
            this.init_method.invoke(this.program_instance, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Logger.error(String.valueOf(th.getName()) + " Program initialisation call failed", t);
        }
        try {
            this.real_method.invoke(this.program_instance, oargs);
        }
        catch (Throwable t) {
            t.printStackTrace();
            String error = String.valueOf(th.getName()) + " failed\n" + this.getStack();
            if (t instanceof InvocationTargetException) {
                Throwable ul = ((InvocationTargetException)t).getTargetException();
                Logger.error(error, ul);
                if (ul instanceof BPELFault) {
                    if (((BPELFault)ul).getUnderlyingThrowable() != null) {
                        Logger.error(error, ((BPELFault)ul).getUnderlyingThrowable());
                    } else {
                        Logger.error(error, ul);
                    }
                }
            } else {
                Logger.error(error, t);
            }
            try {
                this.parent.print("Runner died unexpectedly " + error);
                this.parent.terminate();
            }
            catch (Exception exception) {
                try {
                    this.parent.terminate();
                }
                catch (Exception exception2) {}
            }
        }
        try {
            this.parent.notifyRunnerDeath(this.id, this);
        }
        catch (Throwable t) {
            Logger.error(String.valueOf(th.getName()) + " failed to notify controller of death", t);
        }
    }

    public String getStackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public HashMap getEngineLocalStorageMap(String name) {
        return this.parent.getEngineLocalStorageMap(name);
    }

    public ClassLoader getProgramClassLoader() {
        return this.program_instance.getClass().getClassLoader();
    }

    public String[] getVariablesArray() throws Exception {
        String[] variable_names = this.parent.getVariableNames();
        return variable_names;
    }

    public ArrayList getVariablesList() throws Exception {
        String[] variable_names = this.parent.getVariableNames();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < variable_names.length) {
            list.add(variable_names[i]);
            ++i;
        }
        return list;
    }

    public String getHost() throws Exception {
        return this.parent.getHost();
    }

    public String getClientHost() throws Exception {
        return this.parent.getClientHost();
    }

    public String[] getHostsArray() throws Exception {
        if (this.hosts_cache == null) {
            this.hosts_cache = this.parent.getHosts();
        }
        String[] hosts = new String[this.hosts_cache.length];
        System.arraycopy(this.hosts_cache, 0, hosts, 0, hosts.length);
        return hosts;
    }

    public ArrayList getHostsList() throws Exception {
        if (this.hosts_cache == null) {
            this.hosts_cache = this.parent.getHosts();
        }
        ArrayList<String> hosts = new ArrayList<String>();
        int i = 0;
        while (i < this.hosts_cache.length) {
            hosts.add(this.hosts_cache[i]);
            ++i;
        }
        return hosts;
    }

    public void joinRunner(Long rid) throws Exception {
        this.parent.joinRunner(rid);
    }

    public Message sendAndReceiveMessage(String conversation, Message msg, String conversationReturn) throws Exception {
        return this.parent.sendAndReceiveMessage(conversation, msg, conversationReturn);
    }

    public Message sendAndReceiveMessage(String conversation, Message msg, String[] conversationReturns) throws Exception {
        Message m = new Message();
        int i = 0;
        while (i < conversationReturns.length) {
            m.append(conversationReturns[i]);
            ++i;
        }
        return this.parent.sendAndReceiveMessage(conversation, msg, m);
    }

    public void sendMessage(String conversation, Message m) throws Exception {
        this.parent.sendMessage(conversation, m);
    }

    public Message receiveMessage(String conversation) throws Exception {
        return this.parent.receiveMessage(conversation);
    }

    public Message receiveMessage(String conversation, long timeoutMS) throws Exception {
        return this.parent.receiveMessage(conversation, timeoutMS);
    }

    public Message receiveMessage(String[] conversations) throws Exception {
        Message m = new Message();
        int i = 0;
        while (i < conversations.length) {
            m.append(conversations[i]);
            ++i;
        }
        return this.parent.receiveMessage(m);
    }

    public Message receiveMessage(String[] conversations, long timeoutMS) throws Exception {
        Message m = new Message();
        int i = 0;
        while (i < conversations.length) {
            m.append(conversations[i]);
            ++i;
        }
        return this.parent.receiveMessage(m, timeoutMS);
    }

    public Message launchRunner(int count, String method, int host_index) throws Exception {
        return this.parent.launchRunner(count, method, host_index);
    }

    public Message launchRunner(int count, String method, int host_index, List args) throws Exception {
        return this.parent.launchRunner(count, method, host_index, args);
    }

    public Message launchRunner(int count, String method, int host_index, Message args) throws Exception {
        return this.parent.launchRunner(count, method, host_index, args);
    }

    public Message launchRunner(int count, String method, int host_index, String[] args) throws Exception {
        return this.parent.launchRunner(count, method, host_index, args);
    }

    public ArrayList launchRunnerLocal(int count, String method) throws Exception {
        return this.parent.launchRunnerLocal(count, method, new ArrayList(1));
    }

    public ArrayList launchRunnerLocal(int count, String method, ArrayList args) throws Exception {
        return this.parent.launchRunnerLocal(count, method, args);
    }

    public Thread asyncProgramMethod(String method, ArrayList data) throws Exception {
        DataThread thread = new DataThread(this.program_instance, method, data);
        thread.start();
        return thread;
    }

    public SharedBarrier newBarrier(String name, int size) throws Exception {
        return this.parent.newBarrier(name, size);
    }

    public SharedMutex newMutex(String name) throws Exception {
        return this.parent.newMutex(name);
    }

    public SharedSemaphore newSemaphore(String name, int initial) throws Exception {
        return this.parent.newSemaphore(name, initial);
    }

    public SharedVariable newVariable(String name, int type, boolean dirty) throws Exception {
        return this.parent.newVariable(name, type, dirty);
    }

    public SharedHashMap newHashMap(String name) throws Exception {
        return this.parent.newHashMap(name);
    }

    public SharedSemaphore getSemaphore(String name) throws Exception {
        return this.parent.getSemaphore(name);
    }

    public SharedBarrier getBarrier(String name) throws Exception {
        return this.parent.getBarrier(name);
    }

    public SharedMutex getMutex(String name) throws Exception {
        return this.parent.getMutex(name);
    }

    public SharedVariable getVariable(String name) throws Exception {
        return this.parent.getVariable(name);
    }

    public SharedHashMap getHashMap(String name) throws Exception {
        return this.parent.getHashMap(name);
    }

    public void setPrintHandler(PrintHandler handler) throws Exception {
        this.parent.setPrintHandler(handler);
    }

    public void trace(Message m) throws Exception {
        this.parent.trace(m);
    }

    public void print(String msg) throws Exception {
        this.parent.print(msg);
    }

    public void print(Object msg) throws Exception {
        this.parent.print("" + msg);
    }

    public void debug(String msg) throws Exception {
        this.parent.debug(msg);
    }

    public void debug(Object msg) throws Exception {
        this.parent.debug("" + msg);
    }

    public long getRunnerId() {
        return this.id;
    }

    public String getRunnerIdHex() {
        return ID.ID_HEX(this.id);
    }

    public long getClock() {
        return this.parent.getClock();
    }

    public void terminate() throws Exception {
        this.parent.terminate();
    }
}

