/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.extensionpoints;

import java.util.ArrayList;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.b2j.ui.UiPlugin;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.BPELProvider;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.BPELProviderCategory;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.BPELProviderNode;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.ImageProvider;

/**
 * 
 * @author amiguel
 *
 * A utility class to load all extensions of the Session Transport extension point
 */
public class BPELProviderLoader {

	public static BPELProviderCategory getProviders() throws Exception {
		ArrayList providers = getExtensionPointClasses(UiPlugin.EXTENSION_POINT_BPELPROVIDER);
		
		BPELProviderCategory all = new BPELProviderCategory("all","","",null);
		
		boolean modified = true;
		
		while (providers.size() > 0 && modified) {
			modified = false;
			for (int i = 0; i < providers.size(); i++) {
				Object o = providers.get(i);
				
				if (o instanceof BPELProviderCategory) {
					BPELProviderCategory category = (BPELProviderCategory)o;

System.out.println("Searching for ["+category.getParentId()+"]");					
					BPELProviderCategory parent = all.getCategory(category.getParentId());
					
					if (parent != null) {
						parent.add(category);
						modified = true;
						
						providers.remove(i--);
						
						System.out.println("Added Category "+category);
					}

				} else {
					BPELProviderNode provider = (BPELProviderNode)o;
	
System.out.println("Searching for ["+provider.getCategoryId()+"]");					
					BPELProviderCategory parent = all.getCategory(provider.getCategoryId());
					
					if (parent != null) {
						parent.add(provider);
						modified = true;

						providers.remove(i--);

						System.out.println("Added Provider "+provider);
					}
				}
			}
		}
		
		for (int i = 0; i < providers.size(); i++) {
			Object o = providers.get(i);
			
			if (o instanceof BPELProviderCategory) {
				BPELProviderCategory category = (BPELProviderCategory)o;
				all.add(category);
				System.out.println("Added root Category "+category);
			} else {
				BPELProviderNode provider = (BPELProviderNode)o;
				all.add(provider);
				System.out.println("Added root Provider "+provider);
			}
		}
		
		return all;
	}
		
	private static ArrayList getExtensionPointClasses(String extensionpointid) throws CoreException {
		
		ArrayList transports = new ArrayList();
		
		IExtensionRegistry registry = Platform.getExtensionRegistry();
//Print out all available extension points		
//		IExtensionPoint[] points = registry.getExtensionPoints();
//		for (int i = 0; i < points.length; i++) {
//			System.out.println("POINT:"+points[i].getUniqueIdentifier());
//		}
		
		IExtensionPoint point = registry.getExtensionPoint(extensionpointid);
		IExtension[] extensions = point.getExtensions();

		if (extensions != null) {
		
			for (int i = 0; i < extensions.length; i++) {
				IConfigurationElement[] configs = extensions[i].getConfigurationElements();
				
				for (int z = 0; z < configs.length; z++) {
					if (configs[z].getName().equals("bpel_provider_category")) {
						//required
						String id = configs[z].getAttribute("id");
						String name = configs[z].getAttribute("name");
						//optional
						String parentId = configs[z].getAttribute("parentId");
						ImageProvider imgProvider = null;
						if (configs[z].getAttribute("imageProvider") != null) {
							imgProvider = (ImageProvider)configs[z].createExecutableExtension("imageProvider");
						}
						
						System.out.println("Category: "+id+" "+name+" "+parentId);
						
						BPELProviderCategory category = new BPELProviderCategory(name,id,parentId,imgProvider);
					
						transports.add(category);
						
					} else if (configs[z].getName().equals("bpel_provider")) {
						//required
						String id = configs[z].getAttribute("id");
						String name = configs[z].getAttribute("name");
						String categoryId = configs[z].getAttribute("categoryId");
						BPELProvider provider = (BPELProvider)configs[z].createExecutableExtension("class");
						//optional
						ImageProvider imgProvider = null;
						if (configs[z].getAttribute("imageProvider") != null) {
							imgProvider = (ImageProvider)configs[z].createExecutableExtension("imageProvider");
						}

						System.out.println("Provider: "+id+" "+name+" "+categoryId);
						
						BPELProviderNode providernode = new BPELProviderNode(name,id,categoryId,provider,imgProvider);
						
						transports.add(providernode);
						
					} else {
						System.out.println("Unrecognised configuration element "+configs[z].getName());
					}
				}
			}
		}
		
		UiPlugin.DBG.info("Loaded "+transports.size()+" BPEL Providers and categories");
		
		return transports;
	}		
	
	
}